import type Zone from "./core/zone.js";
import type Template from "./core/template.js";
import type Block from "./core/block.js";
import type EdenMainUi from "./user-interface/page/eden-main-ui.js";
import { EdenMode, type BareTemplates, type GroupedTemplates, type User, type Player } from "./types.js";
export default class Eden {
    zones: Zone[];
    templateDescriptors: {
        [templateName: string]: Template;
    };
    templates: BareTemplates;
    groupedTemplates: GroupedTemplates;
    activeBlock?: Block;
    pageUi: EdenMainUi;
    user: User;
    startedAt: number;
    clientId: string;
    players: Player[];
    cursorPosition: number;
    socket: WebSocket;
    playerUpdateInterval?: number;
    init: () => void;
    start: () => Promise<void>;
    getTimestamp: () => Promise<void>;
    register: () => Promise<void>;
    analyse: () => Promise<void>;
    addZone: (zoneElement: HTMLElement) => Promise<Zone>;
    stop: () => void;
    cleanRefs: () => void;
    activate: () => void;
    desactivate: () => void;
    preSave: () => void;
    save: () => Promise<void>;
    postSave: (error: string) => void;
    cleanMarkup: () => void;
    getActiveBlock: () => Block | undefined;
    setActiveBlock: (block?: Block) => void;
    logout: () => Promise<void>;
    displayInfo: () => void;
    hideInfo: () => void;
    changeMode: (mode: EdenMode) => void;
}
//# sourceMappingURL=eden.d.ts.map