import typeOf from "../services/type-of.js";
import { htmlStringToElement, htmlStringToElements } from "../services/html.js";
import { put } from "../services/put.js";
import buildUuid from "../services/uuid.js";
import { snackbar } from "../user-interface/common/eden-snackbar.js";
import t from "../i18n/index.js";
export default class Template {
    constructor(descriptor) {
        this.createElement = (templateCode, zone, variant) => {
            const block = document.createElement("section");
            block.setAttribute("data-template", templateCode);
            if (zone?.withUuid) {
                const uuid = buildUuid();
                block.setAttribute("data-uuid", uuid);
            }
            if (this.cssClass !== undefined) {
                const cssClasses = this.cssClass.split(" ");
                cssClasses.forEach((cssClass) => {
                    if (cssClass.trim().length > 0) {
                        block.classList.add(cssClass);
                    }
                });
            }
            if (variant) {
                block.classList.add(variant);
            }
            recursCreateElement(block, this.templates, "");
            return block;
        };
        this.getVariant = (block) => {
            return this.variants
                ? this.variants.find((variant) => block.classList.contains(variant.cssClass))?.cssClass
                : undefined;
        };
        this.getAttributes = (block) => {
            return this.attributes && this.attributes?.length > 0
                ? this.attributes.reduce((acc, { property, name = property, placeholder = "", options, allowMultipleOptions, helper, }) => {
                    const value = block.getAttribute(property);
                    return {
                        ...acc,
                        [property]: {
                            name,
                            value: value,
                            placeholder,
                            options,
                            allowMultipleOptions,
                            helper,
                        },
                    };
                }, {})
                : undefined;
        };
        if (descriptor instanceof Template) {
            this.templates = descriptor.templates;
        }
        else {
            this.templates = descriptor.markup;
        }
        this.name = descriptor.name;
        this.cssClass = descriptor.cssClass;
        this.group = descriptor.group;
        this.groups = descriptor.groups;
        this.variants = descriptor.variants;
        this.defaultVariantName = descriptor.defaultVariantName;
        this.attributes = descriptor.attributes;
    }
}
function recursCreateElement(parent, node, parentSelector) {
    const element = parentSelector.length === 0 ? parent : parent.querySelector(parentSelector);
    if (!element) {
        snackbar(t("snackbars.bricks-init-error"), "error");
        return;
    }
    const nodeAsObject = node;
    for (let templateName in nodeAsObject) {
        const templateDescriptor = nodeAsObject[templateName];
        const brickType = typeOf(templateDescriptor.type);
        const markupType = typeOf(templateDescriptor.markup);
        const tmp = put(element, templateName);
        if (!tmp) {
            continue;
        }
        if (("undefined" === markupType && "undefined" === brickType) ||
            "object" === markupType) {
            const next = ("object" === markupType ? templateDescriptor.markup : templateDescriptor);
            recursCreateElement(element, next, templateName);
        }
        else if ("array" === markupType) {
            const markup = templateDescriptor.markup;
            if (templateDescriptor.type === "Recursive") {
                return;
            }
            const child = htmlStringToElement(markup[0].markup);
            if (!tmp || !child) {
                continue;
            }
            tmp.append(child);
        }
        else if (templateDescriptor.type === "Recursive") {
            return;
        }
        else {
            Array.from(htmlStringToElements(templateDescriptor.markup)).forEach((element) => tmp.append(element));
        }
    }
}
