import { isLocalhost } from "../services/util.js";
import t from "../i18n/index.js";
export default class Brick {
    constructor({ block, element, parentBricks }) {
        this.cleanRefs = () => {
            delete this.block;
            delete this.parentBricks;
        };
        this.handleClick = (e) => {
            e?.preventDefault();
            e?.stopPropagation();
            this.block?.manageActions([...(this.parentBricks || []), this]);
        };
        this.block = block;
        this.element = element;
        if (element === null && !block.obsolete) {
            block.obsolete = true;
            if (isLocalhost()) {
                console.info(t("console.obsolete-block"), block.element, t("console.obsolete-block-message"));
            }
        }
        this.parentBricks = parentBricks;
        this.descriptor = "";
    }
    preSave() { }
    postSave() { }
    activate() { }
    desactivate() { }
    hasParents(target, nodeName) {
        if (target === null || target.nodeName === nodeName.toUpperCase()) {
            return target;
        }
        if (target !== this.element) {
            return this.hasParents(target.parentNode, nodeName);
        }
    }
}
function applytoElement(fn) {
    return (element) => {
        if (element === undefined)
            return;
        const array = Array.isArray(element) ? element : [element];
        array.forEach(fn);
    };
}
export const setEditable = applytoElement((element) => {
    try {
        const original = element.style.captionSide;
        element.style.captionSide = "workaround-chrome-bug";
        element.style.captionSide = original;
        element.setAttribute("contentEditable", "true");
    }
    catch { }
});
export const unsetEditable = applytoElement((element) => {
    try {
        element.removeAttribute("contentEditable");
    }
    catch { }
});
