import type Block from "./block.js";
import type { Action, BrickConstructor } from "../types.js";
export default class Brick {
    element: HTMLElement;
    block?: Block;
    parentBricks?: Brick[];
    descriptor: string;
    actions: Action[];
    watchSelectionChange?: boolean;
    constructor({ block, element, parentBricks }: BrickConstructor);
    cleanRefs: () => void;
    handleClick: (e?: MouseEvent) => void;
    preSave(): void;
    postSave(): void;
    activate(): void;
    desactivate(): void;
    hasParents(target: HTMLElement | null, nodeName: string): HTMLElement | null | undefined;
}
export declare const setEditable: (element: HTMLElement | HTMLElement[]) => void;
export declare const unsetEditable: (element: HTMLElement | HTMLElement[]) => void;
//# sourceMappingURL=brick.d.ts.map