import Brick from "../core/brick.js";
import type { BrickConstructor, PictureOptions } from "../types.js";
export default class Picture extends Brick {
    image: HTMLImageElement | null;
    sizes?: PictureOptions["sizes"];
    markup?: string;
    constructor({ block, element, parentBricks, options, markup, }: BrickConstructor);
    private shouldShowCropAction;
    private createReplaceImageAction;
    private createCropAction;
    private createImageSettingsAction;
    private createRemoveImageAction;
    private getImageAttributes;
    private getImageDimensions;
    buildActions: () => void;
    refresh: () => Promise<void>;
    openFilePicker: (withMetadata?: boolean) => Promise<void>;
    openMutlipleSizedImageModal: () => Promise<void>;
    private createSimpleImageCallback;
    private createMultipleSizedImageCallback;
    preSave: () => void;
    updateAttributes: (description: string, credits: string, loading: string) => void;
    updateAlt: (text: string) => void;
    updateCredits: (text: string) => void;
    updateLoading: (loading: string) => void;
    activate: () => void;
    desactivate: () => void;
}
//# sourceMappingURL=Picture.d.ts.map