const SLASH = "/";
const PDF_REGEX = /.*\.pdf$/;
function isPdfUrl(href) {
    return href !== null && href !== undefined && PDF_REGEX.exec(href) !== null;
}
export function toStatic(path) {
    const [basePath, anchor] = path.split("#");
    const isPDF = isPdfUrl(basePath);
    const isExternal = !isRelative(basePath);
    const mustFixPath = !isExternal && !isPDF && !endsWith(basePath, SLASH);
    const newPath = mustFixPath ? basePath.concat(SLASH) : basePath;
    return anchor ? newPath.concat("#", anchor) : newPath;
}
export function toLocalized(path, lang, langPrefix) {
    if (!langPrefix)
        return path;
    return `/${lang}`.concat(path);
}
function endsWith(str, char) {
    return str !== undefined && str.length > 0 && str[str.length - 1] === char;
}
export function getRelative(path) {
    if (!path)
        return;
    const host = window.location.protocol.concat("//", window.location.host);
    const uri = path.includes(host) ? path.replace(host, "") : path;
    if (isRelative(uri)) {
        return uri;
    }
}
function isRelative(path) {
    if (typeof path !== "string")
        return false;
    return path.startsWith("/") && !path.startsWith("//") && !path.includes(".");
}
