import { describe, it, expect } from "vitest";
import { format } from "../layouts";
describe("format", () => {
    it("should format a single regular layout", () => {
        const result = format(["/home"]);
        expect(result).toEqual([{ name: "Home", view: "/home" }]);
    });
    it("should format index layout with special handling", () => {
        const result = format(["/"]);
        expect(result).toEqual([{ name: "Index", view: "/" }]);
    });
    it("should format multiple layouts", () => {
        const result = format(["/home", "/about", "/contact"]);
        expect(result).toEqual([
            { name: "Home", view: "/home" },
            { name: "About", view: "/about" },
            { name: "Contact", view: "/contact" },
        ]);
    });
    it("should format hyphenated layout names", () => {
        const result = format(["/about-us"]);
        expect(result).toEqual([{ name: "About Us", view: "/about-us" }]);
    });
    it("should format multi-hyphenated layout names", () => {
        const result = format(["/contact-us-today"]);
        expect(result).toEqual([
            { name: "Contact Us Today", view: "/contact-us-today" },
        ]);
    });
    it("should handle mixed layouts including index", () => {
        const result = format(["/", "/home", "/about-us"]);
        expect(result).toEqual([
            { name: "Index", view: "/" },
            { name: "Home", view: "/home" },
            { name: "About Us", view: "/about-us" },
        ]);
    });
    it("should handle empty array", () => {
        const result = format([]);
        expect(result).toEqual([]);
    });
    it("should capitalize each word correctly", () => {
        const result = format(["/my-awesome-page"]);
        expect(result).toEqual([
            { name: "My Awesome Page", view: "/my-awesome-page" },
        ]);
    });
    it("should handle single character words", () => {
        const result = format(["/a-b-c"]);
        expect(result).toEqual([{ name: "A B C", view: "/a-b-c" }]);
    });
    it("should handle layouts with numbers", () => {
        const result = format(["/page-2"]);
        expect(result).toEqual([{ name: "Page 2", view: "/page-2" }]);
    });
    it("should preserve original view value", () => {
        const result = format(["/UPPERCASE"]);
        expect(result).toEqual([{ name: "UPPERCASE", view: "/UPPERCASE" }]);
    });
    it("should handle nested path-like layouts", () => {
        const result = format(["/blog/post"]);
        expect(result).toEqual([{ name: "Blog/post", view: "/blog/post" }]);
    });
});
