import type Eden from "../@editing-tools/eden";
export type EdenMode = "connected" | "info" | "editing" | null;
declare global {
    interface Window {
        ace: any;
        Eden: Eden;
        EdenConfig: Record<string, any>;
        setEdenMode: React.Dispatch<React.SetStateAction<EdenMode | null>>;
        updateEdenDraftMode: (status: boolean, token: string) => Promise<any>;
    }
}
export type MenuPathItem = {
    id: number;
    active: boolean;
    disabled: boolean;
    highlight?: boolean;
    name: string;
    title: string;
    subTitle?: string;
    shortTitle?: string;
    menu: string;
    path: string;
    page?: string;
    prev: MenuPathItem | null;
    next: MenuPathItem | null;
    metadata?: Record<string, string | number | boolean>;
};
export type NavigationItem = {
    highlight?: boolean;
    name: string;
    title: string;
    subTitle?: string;
    shortTitle?: string;
    menu: string;
    path: string;
    page?: string;
    subs?: NavigationItem[];
    metadata?: Record<string, string | number | boolean>;
};
type Seo = {
    title?: any;
    description?: any;
    robots?: any;
    canonical?: any;
    keywords?: any;
};
type Metadata = Record<number | string, number | string | boolean>;
type LangSwitches = Record<string, {
    path: string;
    page: string;
    disabled: boolean;
}>;
export type EdenContext = {
    edenApi: string;
    site: string;
    lang: string;
    path: string;
    edenMode: EdenMode;
    menuPath: MenuPathItem;
    breadcrumb: MenuPathItem;
    seo: Seo;
    metadata: Metadata;
    config: Record<string, any>;
    domain?: string;
    langSwitches: LangSwitches;
    zones: Record<string, string>;
    isConnected: boolean;
    pageProps: Record<string, unknown>;
};
export type LayoutEdenContext<T = Record<string, unknown>> = T & {
    layout: string;
    lang: string;
    path: string;
    domain?: string;
    menuPath: MenuPathItem;
    zones: Record<string, string>;
    breadcrumb: MenuPathItem;
    site: string;
    edenApi: string;
    seo: Seo;
    metadata: Metadata;
    langSwitches: LangSwitches;
};
export type Config = {
    edenApi: string;
    site: string;
    siteName: string;
    lang: string;
    langs: string[];
    domains: Record<string, string>;
    preProd?: boolean | string[];
    layout: string;
    layouts: {
        name: string;
        view: string;
    }[];
    langPrefix: boolean;
};
export type EdenNextConfig = {
    site: string;
    edenApi: string;
    langs: string[];
    langPrefix: boolean;
    domains: Record<string, string>;
    siteName: string;
    preProd?: boolean | string[];
};
export {};
//# sourceMappingURL=types.d.ts.map