export function reverse(item) {
    if (!item)
        return null;
    if (item?.next === null) {
        return item;
    }
    const next = reverse(item.next);
    item.next.prev = item;
    item.next = null;
    return next;
}
export function deepClone(item) {
    if (!item)
        return null;
    const { next, ...rest } = item;
    if (next === null)
        return { ...rest, next: null };
    return { ...rest, next: deepClone(next) };
}
