import { GET, POST, getJson } from "../utils/http";
export async function checkToken(host, token) {
    return POST(host, "/admin/login/check", {}, { authorization: token });
}
export async function login(host, site, email, password) {
    return POST(host, "/admin/login", { site, email, password });
}
export async function getPage(host, site, lang, path, skipReverse = false) {
    return GET(host, "/page", {
        site,
        lang,
        path,
        skipReverse: String(skipReverse),
    });
}
export async function getSeo(host, site, lang, path) {
    return GET(host, "/seo", { site, lang, path });
}
export async function getLocalizedPath(host, site, langs, currentLang, path, targetLang) {
    const result = await GET(host, "/lang-switches", {
        site,
        langs: langs.join(","),
        currentLang,
        path,
    });
    return result?.[targetLang]?.path || null;
}
export async function getLangSwitches(host, site, currentLang, langs, path) {
    if (langs.length < 2)
        return {};
    return GET(host, "/lang-switches", {
        site,
        currentLang,
        langs: langs.join(","),
        path,
    });
}
export async function getExportPathMap(host, site, lang, ignoreMounted = true) {
    return GET(host, "/export-path-map", {
        site,
        langs: lang,
        ignoreMounted: String(ignoreMounted),
    });
}
export async function getConfig() {
    return getJson("/static/cms/config.json");
}
export async function updateDraftMode(status, token) {
    return getJson(`/api/draft?status=${status}&token=${token}`);
}
export async function requestPasswordReset(host, site, email, lang) {
    return POST(host, "/admin/login/reset", { site, email, lang });
}
export async function confirmPasswordReset(host, site, oldPassword, newPassword, token) {
    return POST(host, "/admin/login/reset-confirm", { site, oldPassword, newPassword }, { authorization: token });
}
