import * as React from "react";
import { usePathname } from "next/navigation";
import { useEdenContext } from "../components/context";
export default function useDateHiddenBlocks() {
    const pathname = usePathname();
    const { lang, path, edenMode } = useEdenContext();
    React.useEffect(() => {
        if (!edenMode) {
            filter();
            return () => {
                removeFilter();
            };
        }
    }, [edenMode, lang, path, pathname]);
}
function getFiltrableBlocks() {
    return Array.from(document.querySelectorAll("section[data-dates]"));
}
function filter() {
    const now = new Date();
    window.requestAnimationFrame(() => window.requestAnimationFrame(() => {
        const filtrables = getFiltrableBlocks();
        filtrables.forEach((block) => {
            const elementDates = block.dataset.dates;
            if (!elementDates)
                return;
            const dates = JSON.parse(elementDates);
            const visible = dates.some(([start, end]) => {
                const dateStart = new Date(start);
                const dateEnd = new Date(end);
                return dateStart <= now && now <= dateEnd;
            });
            if (block.originalDisplayStyle === undefined) {
                block.originalDisplayStyle = block.style.display;
            }
            if (visible) {
                if (block.originalDisplayStyle !== undefined &&
                    block.originalDisplayStyle !== "none") {
                    block.style.setProperty("display", block.originalDisplayStyle);
                }
                else {
                    block.style.removeProperty("display");
                }
            }
            else {
                block.style.setProperty("display", "none");
            }
        });
    }));
}
function removeFilter() {
    const filtrables = getFiltrableBlocks();
    filtrables.forEach((block) => {
        if (block.originalDisplayStyle !== undefined &&
            block.originalDisplayStyle !== "none") {
            block.style.display = block.originalDisplayStyle;
        }
        else {
            block.style.removeProperty("display");
        }
    });
}
