import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useEdenContext } from "./context";
function Zone({ tag, ref, code, className, tooltip, templates, fixed, content, maxBlocks, tagsLabel, allowedTags, allowMultipleTags, defaultContent, readOnly, uuid, }) {
    const { lang, path, zones } = useEdenContext();
    const zone = zones[code];
    const html = content || zone || "";
    const Tag = tag || "div";
    const key = `/${lang}${path}`;
    const props = {
        ref,
        className,
        "data-eden-zone": code,
        "data-eden-tooltip": tooltip,
        "data-eden-fixed": fixed,
        "data-eden-templates": templates,
        "data-eden-max-blocks": maxBlocks,
        "data-eden-default-content": defaultContent,
        "data-eden-tags-label": tagsLabel,
        "data-eden-allowed-tags": allowedTags?.join(","),
        "data-eden-allow-multiple-tags": allowMultipleTags,
        "data-eden-read-only": readOnly,
        "data-eden-uuid": uuid,
        "aria-hidden": readOnly,
        dangerouslySetInnerHTML: React.useMemo(() => ({ __html: html }), [html]),
    };
    return _jsx(Tag, { ...props }, key);
}
export default Zone;
