import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEdenContext } from "../context";
import EnterKey from "../icons/enter-key";
import Loading from "../icons/loading";
import * as API from "../../services/api";
import styles from "./styles.module.css";
import Logo from "../logo";
import t from "./i18n";
export default function Reset({ lang, onBack }) {
    const [email, setEmail] = React.useState("");
    const [error, setError] = React.useState("");
    const [success, setSuccess] = React.useState("");
    const [loading, setLoading] = React.useState(false);
    const { edenApi, site } = useEdenContext();
    const sendResetEmail = async (e) => {
        setLoading(true);
        setError("");
        setSuccess("");
        e.preventDefault();
        try {
            const { error } = await API.requestPasswordReset(edenApi, site, email, lang);
            if (error) {
                const message = error.message === "User not found"
                    ? t(lang, "wrong-credentials")
                    : error.message || "Failed to send reset email";
                setError(message);
                setLoading(false);
                return;
            }
            setSuccess(t(lang, "reset-confirmation", { email }));
            setEmail("");
            setLoading(false);
        }
        catch (err) {
            setError("An error occurred. Please try again.");
            setLoading(false);
        }
    };
    return (_jsxs("form", { className: styles.login, onSubmit: sendResetEmail, children: [_jsx(Logo, { className: styles.logo }), _jsxs("label", { className: styles.email, children: [_jsx("span", { className: styles.label, children: t(lang, "email") }), _jsx("div", { className: styles.inputWrapper, children: _jsx("input", { type: "email", name: "email", autoComplete: "email", value: email, onChange: updateField(setEmail), className: styles.input, autoFocus: true, required: true }) })] }), error && _jsx("div", { className: styles.error, children: error }), success && _jsx("div", { className: styles.success, children: success }), _jsxs("button", { type: "submit", className: styles.button, disabled: loading, children: [t(lang, "send-reset-email"), loading ? (_jsx(Loading, { className: styles.loadingIcon })) : (_jsx(EnterKey, { className: styles.buttonIcon }))] }), onBack && (_jsx("button", { type: "button", className: styles.linkButton, onClick: onBack, children: t(lang, "login") }))] }));
}
function updateField(setValue) {
    return (e) => {
        setValue(e.target.value);
    };
}
