import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEdenContext } from "../context";
import Eye from "../icons/eye";
import EyeOff from "../icons/eye-off";
import EnterKey from "../icons/enter-key";
import Loading from "../icons/loading";
import * as CMS from "../../services/eden";
import * as API from "../../services/api";
import styles from "./styles.module.css";
import Logo from "../logo";
import t from "./i18n";
export default function ResetConfirm({ lang, onBack }) {
    const [oldPassword, setOldPassword] = React.useState("");
    const [newPassword, setNewPassword] = React.useState("");
    const [confirmPassword, setConfirmPassword] = React.useState("");
    const [error, setError] = React.useState("");
    const [success, setSuccess] = React.useState("");
    const [loading, setLoading] = React.useState(false);
    const [oldPasswordVisible, setOldPasswordVisible] = React.useState(false);
    const [newPasswordVisible, setNewPasswordVisible] = React.useState(false);
    const [confirmPasswordVisible, setConfirmPasswordVisible] = React.useState(false);
    const { edenApi, site, config } = useEdenContext();
    const toggleOldPasswordVisibility = () => {
        setOldPasswordVisible(!oldPasswordVisible);
    };
    const toggleNewPasswordVisibility = () => {
        setNewPasswordVisible(!newPasswordVisible);
    };
    const toggleConfirmPasswordVisibility = () => {
        setConfirmPasswordVisible(!confirmPasswordVisible);
    };
    const OldPasswordVisibilityIcon = oldPasswordVisible ? Eye : EyeOff;
    const NewPasswordVisibilityIcon = newPasswordVisible ? Eye : EyeOff;
    const ConfirmPasswordVisibilityIcon = confirmPasswordVisible ? Eye : EyeOff;
    const resetPassword = async (e) => {
        setLoading(true);
        setError("");
        setSuccess("");
        e.preventDefault();
        if (newPassword !== confirmPassword) {
            setError(t(lang, "passwords-do-not-match"));
            setLoading(false);
            return;
        }
        try {
            const token = sessionStorage.getItem(CMS.EDEN_TOKEN);
            if (!token) {
                setError("Session expired. Please log in again.");
                setLoading(false);
                return;
            }
            const { token: newToken, error } = await API.confirmPasswordReset(edenApi, site, oldPassword, newPassword, token);
            if (error) {
                const message = error.message === "Invalid credentials"
                    ? t(lang, "wrong-credentials")
                    : error.message || "Failed to reset password";
                setError(message);
                setLoading(false);
                return;
            }
            sessionStorage.setItem(CMS.EDEN_TOKEN, newToken);
            setSuccess(t(lang, "reset-success"));
            setOldPassword("");
            setNewPassword("");
            setConfirmPassword("");
            setLoading(false);
            setTimeout(() => {
                const hasLangPrefix = config.langPrefix;
                window.location.href = hasLangPrefix ? `/${lang}/` : "/";
            }, 1500);
        }
        catch (err) {
            setError("An error occurred. Please try again.");
            setLoading(false);
        }
    };
    return (_jsxs("form", { className: styles.login, onSubmit: resetPassword, children: [_jsx(Logo, { className: styles.logo }), _jsxs("label", { className: styles.password, children: [_jsx("span", { className: styles.label, children: t(lang, "old-password") }), _jsxs("div", { className: styles.inputWrapper, children: [_jsx("input", { type: oldPasswordVisible ? "text" : "password", name: "old-password", autoComplete: "current-password", value: oldPassword, onChange: updateField(setOldPassword), className: styles.input, autoFocus: true, required: true }), _jsx("button", { className: styles.passwordVisibilityButton, onClick: toggleOldPasswordVisibility, type: "button", children: _jsx(OldPasswordVisibilityIcon, { className: styles.passwordVisibilityIcon }) })] })] }), _jsxs("label", { className: styles.password, children: [_jsx("span", { className: styles.label, children: t(lang, "new-password") }), _jsxs("div", { className: styles.inputWrapper, children: [_jsx("input", { type: newPasswordVisible ? "text" : "password", name: "new-password", autoComplete: "new-password", value: newPassword, onChange: updateField(setNewPassword), className: styles.input, required: true }), _jsx("button", { className: styles.passwordVisibilityButton, onClick: toggleNewPasswordVisibility, type: "button", children: _jsx(NewPasswordVisibilityIcon, { className: styles.passwordVisibilityIcon }) })] })] }), _jsxs("label", { className: styles.password, children: [_jsx("span", { className: styles.label, children: t(lang, "confirm-new-password") }), _jsxs("div", { className: styles.inputWrapper, children: [_jsx("input", { type: confirmPasswordVisible ? "text" : "password", name: "confirm-new-password", autoComplete: "new-password", value: confirmPassword, onChange: updateField(setConfirmPassword), className: styles.input, required: true }), _jsx("button", { className: styles.passwordVisibilityButton, onClick: toggleConfirmPasswordVisibility, type: "button", children: _jsx(ConfirmPasswordVisibilityIcon, { className: styles.passwordVisibilityIcon }) })] })] }), error && _jsx("div", { className: styles.error, children: error }), success && _jsx("div", { className: styles.success, children: success }), _jsxs("button", { type: "submit", className: styles.button, disabled: loading, children: [t(lang, "confirm-reset"), loading ? (_jsx(Loading, { className: styles.loadingIcon })) : (_jsx(EnterKey, { className: styles.buttonIcon }))] }), onBack && !success && (_jsx("button", { type: "button", className: styles.linkButton, onClick: onBack, children: t(lang, "login") }))] }));
}
function updateField(setValue) {
    return (e) => {
        setValue(e.target.value);
    };
}
