import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEdenContext } from "../context";
import Eye from "../icons/eye";
import EyeOff from "../icons/eye-off";
import EnterKey from "../icons/enter-key";
import Loading from "../icons/loading";
import * as CMS from "../../services/eden";
import * as API from "../../services/api";
import styles from "./styles.module.css";
import Logo from "../logo";
import t from "./i18n";
import Reset from "./reset";
import ResetConfirm from "./reset-confirm";
export default function Login() {
    const [ready, setReady] = React.useState(false);
    const [lang, setLang] = React.useState("en");
    const [currentForm, setCurrentForm] = React.useState("login");
    const [email, setEmail] = React.useState("");
    const [password, setPassword] = React.useState("");
    const [error, setError] = React.useState("");
    const [loading, setLoading] = React.useState(false);
    const [passwordVisible, setPasswordVisible] = React.useState(false);
    const togglePasswordVisibility = () => {
        setPasswordVisible(!passwordVisible);
    };
    const PasswordVisibilityIcon = passwordVisible ? Eye : EyeOff;
    const { edenApi, site, config } = useEdenContext();
    const hasLangPrefix = config.langPrefix;
    const login = async (e) => {
        setLoading(true);
        e.preventDefault();
        const { token, requiresPasswordChange, error } = await API.login(edenApi, site, email, password);
        if (error) {
            const message = error.message === "Invalid credentials"
                ? t(lang, "wrong-credentials")
                : error.message;
            setError(message);
            setLoading(false);
            return;
        }
        sessionStorage.setItem(CMS.EDEN_TOKEN, token);
        if (requiresPasswordChange) {
            setCurrentForm("reset-confirm");
            setLoading(false);
            return;
        }
        await API.updateDraftMode(true, token);
        setLoading(false);
        window.location.href = hasLangPrefix ? `/${lang}/` : "/";
    };
    const handleResetClick = () => {
        setCurrentForm("reset");
        setError("");
    };
    const handleBackToLogin = () => {
        setCurrentForm("login");
        setError("");
    };
    React.useEffect(() => {
        const userLang = navigator.language.startsWith("fr") ? "fr" : "en";
        setLang(userLang);
        setReady(true);
    }, []);
    if (!ready) {
        return null;
    }
    if (currentForm === "reset") {
        return _jsx(Reset, { lang: lang, onBack: handleBackToLogin });
    }
    if (currentForm === "reset-confirm") {
        return _jsx(ResetConfirm, { lang: lang, onBack: handleBackToLogin });
    }
    return (_jsxs("form", { className: styles.login, onSubmit: login, children: [_jsx(Logo, { className: styles.logo }), _jsxs("label", { className: styles.email, children: [_jsx("span", { className: styles.label, children: t(lang, "email") }), _jsx("div", { className: styles.inputWrapper, children: _jsx("input", { type: "text", name: "email", autoComplete: "email", value: email, onChange: updateField(setEmail), className: styles.input, autoFocus: true }) })] }), _jsxs("label", { className: styles.password, children: [_jsx("span", { className: styles.label, children: t(lang, "password") }), _jsxs("div", { className: styles.inputWrapper, children: [_jsx("input", { type: passwordVisible ? "text" : "password", name: "password", autoComplete: "current-password", value: password, onChange: updateField(setPassword), className: styles.input }), _jsx("button", { className: styles.passwordVisibilityButton, onClick: togglePasswordVisibility, type: "button", children: _jsx(PasswordVisibilityIcon, { className: styles.passwordVisibilityIcon }) })] })] }), error && _jsx("div", { className: styles.error, children: error }), _jsxs("button", { type: "submit", className: styles.button, disabled: loading, children: [t(lang, "login"), loading ? (_jsx(Loading, { className: styles.loadingIcon })) : (_jsx(EnterKey, { className: styles.buttonIcon }))] }), _jsx("button", { type: "button", className: styles.linkButton, onClick: handleResetClick, children: t(lang, "forgot-password") })] }));
}
function updateField(setValue) {
    return (e) => {
        setValue(e.target.value);
    };
}
