const fr = {
    email: "E-mail",
    password: "Mot de passe",
    login: "Se connecter",
    "wrong-credentials": "E-mail ou mot de passe incorrect",
    "forgot-password": "Mot de passe oublié",
    "old-password": "Mot de passe temporaire",
    "new-password": "Nouveau mot de passe",
    "confirm-new-password": "Confirmer le nouveau mot de passe",
    "reset-password": "Réinitialiser le mot de passe",
    "reset-confirmation": "Un e-mail de réinitialisation a été envoyé à ${email}",
    "send-reset-email": "Envoyer l'e-mail de réinitialisation",
    "confirm-reset": "Confirmer la réinitialisation",
    "passwords-do-not-match": "Les mots de passe ne correspondent pas",
    "reset-success": "Mot de passe réinitialisé avec succès",
};
const en = {
    email: "Email",
    password: "Password",
    login: "Log in",
    "wrong-credentials": "Wrong email or password",
    "forgot-password": "Forgot password",
    "old-password": "Temporary password",
    "new-password": "New password",
    "confirm-new-password": "Confirm new password",
    "reset-password": "Reset password",
    "reset-confirmation": "A reset email has been sent to ${email}",
    "send-reset-email": "Send reset email",
    "confirm-reset": "Confirm reset",
    "passwords-do-not-match": "Passwords do not match",
    "reset-success": "Password reset successfully",
};
export default function t(lang, code, variables = {}) {
    const parts = code.split(".");
    const translations = lang === "fr" ? fr : en;
    let current = translations;
    for (const part of parts) {
        if (current && typeof current === "object" && part in current) {
            current = current[part];
        }
        else {
            return code;
        }
    }
    if (typeof current !== "string")
        return code;
    const template = current;
    const result = template.replace(/\$\s*\{([^}]+)\}/g, (_, key) => {
        return key in variables ? String(variables[key]) : "";
    });
    return result;
}
