"use client";
import * as React from "react";
import { useEdenContext } from "./context";
import usePatchedInternalLinks from "../hooks/use-patched-internal-links";
import useDateHiddenBlocks from "../hooks/use-date-hidden-blocks";
import * as Eden from "../services/eden";
export default function EdenLoader({ config }) {
    const { isConnected } = useEdenContext();
    usePatchedInternalLinks();
    useDateHiddenBlocks();
    const loadAndStartEden = React.useEffectEvent(async () => {
        await Eden.setup(config);
        const { default: EdenCms } = await import("../../@editing-tools/eden");
        window.Eden = new EdenCms();
        await window.Eden.start();
    });
    React.useEffect(() => {
        if (isConnected) {
            loadAndStartEden();
        }
    }, [isConnected]);
    return null;
}
