"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEdenContext } from "./context";
export default function EdenHead() {
    const { lang, config, menuPath, seo, domain, edenMode, langSwitches } = useEdenContext();
    const { langs, domains, preProd, siteName } = config;
    const isIndex = menuPath?.path === "/";
    const isInPreProdMode = Array.isArray(preProd)
        ? preProd.includes(lang)
        : preProd;
    const bareTitle = (menuPath?.title || menuPath?.name)?.replace(/<[^>]*>?/gm, "") || "";
    const bareSubTitle = menuPath?.subTitle?.replace(/<[^>]*>?/gm, "") || "";
    const fullTitle = bareSubTitle ? `${bareTitle} ${bareSubTitle}` : bareTitle;
    const title = `${fullTitle} - ${siteName}`;
    const pageTitle = seo?.title || title;
    const path = isIndex ? menuPath?.path : menuPath?.path?.concat("/");
    const defaultCanonical = domain && path && `https://${domain}${path}`;
    const canonical = seo?.canonical || defaultCanonical;
    return (_jsxs("head", { children: [_jsx("title", { children: pageTitle }), _jsx("meta", { name: "description", content: seo?.description || "" }), seo?.robots && _jsx("meta", { name: "robots", content: seo.robots }), (menuPath?.disabled || isInPreProdMode) && (_jsx("meta", { name: "robots", content: "noindex, nofollow" })), edenMode && _jsx("meta", { name: "google", content: "notranslate" }), _jsx("meta", { name: "format-detection", content: "telephone=no, date=no, email=no, address=no" }), canonical && _jsx("link", { rel: "canonical", href: canonical }), langs.map((lang) => {
                const domain = domains[lang];
                const langSwitch = langSwitches?.[lang];
                if (!domain || !langSwitch)
                    return null;
                const { path, disabled } = langSwitch;
                if (!path || disabled)
                    return null;
                const isHome = path === "/";
                const pathWithEndSlash = isHome ? path : `${path}/`;
                const url = `https://${domain}${pathWithEndSlash}`;
                return _jsx("link", { rel: "alternate", hrefLang: lang, href: url }, url);
            })] }));
}
