"use client";
import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as CMS from "../services/eden";
import * as API from "../services/api";
const EdenContext = React.createContext({
    pageProps: {},
    config: {},
    zones: {},
    isConnected: false,
    edenApi: "",
    site: "",
    lang: "",
    path: "",
    edenMode: null,
    menuPath: {
        id: 0,
        active: false,
        disabled: false,
        highlight: undefined,
        name: "",
        title: "",
        subTitle: undefined,
        shortTitle: undefined,
        menu: "",
        path: "",
        page: undefined,
        prev: null,
        next: null,
        metadata: undefined,
    },
    breadcrumb: {
        id: 0,
        active: false,
        disabled: false,
        highlight: undefined,
        name: "",
        title: "",
        subTitle: undefined,
        shortTitle: undefined,
        menu: "",
        path: "",
        page: undefined,
        prev: null,
        next: null,
        metadata: undefined,
    },
    seo: {
        title: undefined,
        description: undefined,
        robots: undefined,
        canonical: undefined,
        keywords: undefined,
    },
    metadata: {},
    langSwitches: {},
});
export const useEdenContext = () => React.useContext(EdenContext);
export default function EdenContextProvider({ value, children }) {
    const [isConnected, setIsConnected] = React.useState(false);
    const [edenMode, setEdenMode] = React.useState(null);
    React.useEffect(() => {
        const isConnected = CMS.isConnected();
        setIsConnected(isConnected);
        window.setEdenMode = setEdenMode;
        window.updateEdenDraftMode = API.updateDraftMode;
    }, []);
    return (_jsx(EdenContext, { value: { ...value, edenMode, isConnected }, children: children }));
}
