import { jsx as _jsx } from "react/jsx-runtime";
import { describe, it, expect } from "vitest";
import { render } from "@testing-library/react";
import Logo from "../logo";
describe("Logo", () => {
    it("should render SVG element", () => {
        const { container } = render(_jsx(Logo, {}));
        const svg = container.querySelector("svg");
        expect(svg).toBeTruthy();
    });
    it("should have correct dimensions", () => {
        const { container } = render(_jsx(Logo, {}));
        const svg = container.querySelector("svg");
        expect(svg?.getAttribute("width")).toBe("489");
        expect(svg?.getAttribute("height")).toBe("243");
    });
    it("should have correct viewBox", () => {
        const { container } = render(_jsx(Logo, {}));
        const svg = container.querySelector("svg");
        expect(svg?.getAttribute("viewBox")).toBe("0 0 489 243");
    });
    it("should apply custom className", () => {
        const { container } = render(_jsx(Logo, { className: "custom-logo" }));
        const svg = container.querySelector("svg");
        expect(svg?.classList.contains("custom-logo")).toBe(true);
    });
    it("should not have className when not provided", () => {
        const { container } = render(_jsx(Logo, {}));
        const svg = container.querySelector("svg");
        expect(svg?.getAttribute("class")).toBe(null);
    });
    it("should contain path elements", () => {
        const { container } = render(_jsx(Logo, {}));
        const paths = container.querySelectorAll("path");
        expect(paths.length).toBeGreaterThan(0);
    });
    it("should contain gradient definitions", () => {
        const { container } = render(_jsx(Logo, {}));
        const linearGradients = container.querySelectorAll("linearGradient");
        expect(linearGradients.length).toBeGreaterThan(0);
    });
    it("should have defs section", () => {
        const { container } = render(_jsx(Logo, {}));
        const defs = container.querySelector("defs");
        expect(defs).toBeTruthy();
    });
    it("should render consistently", () => {
        const { container: container1 } = render(_jsx(Logo, {}));
        const { container: container2 } = render(_jsx(Logo, {}));
        const svg1 = container1.querySelector("svg");
        const svg2 = container2.querySelector("svg");
        expect(svg1?.outerHTML).toBe(svg2?.outerHTML);
    });
    it("should be accessible as inline SVG", () => {
        const { container } = render(_jsx(Logo, {}));
        const svg = container.querySelector("svg");
        expect(svg?.getAttribute("xmlns")).toBe("http://www.w3.org/2000/svg");
    });
    it("should contain filter element", () => {
        const { container } = render(_jsx(Logo, {}));
        const filter = container.querySelector("filter");
        expect(filter).toBeTruthy();
    });
    it("should contain group element with filter", () => {
        const { container } = render(_jsx(Logo, {}));
        const g = container.querySelector("g[filter]");
        expect(g).toBeTruthy();
    });
    it("should have proper gradient IDs", () => {
        const { container } = render(_jsx(Logo, {}));
        const gradients = container.querySelectorAll("linearGradient");
        const ids = Array.from(gradients).map((g) => g.getAttribute("id"));
        expect(ids).toContain("paint0_linear_6034_40");
        expect(ids).toContain("paint1_linear_6034_40");
        expect(ids).toContain("paint2_linear_6034_40");
    });
});
