import css from "../../services/css.js";
const theme = css `
  @font-face {
    font-family: "JetBrains Mono";
    src: url("https://eden.jeantinland.com/api/font") format("woff2");
    font-weight: 400;
    font-style: normal;
    font-display: swap;
  }

  :root {
    --eden-view-transition-duration: 240ms;
    --eden-content-font: "JetBrains Mono", ui-monospace, "Cascadia Mono",
      "Segoe UI Mono", "Roboto Mono", Menlo, Monaco, "Oxygen Mono",
      "Ubuntu Monospace", "Source Code Pro", "Fira Mono", "Droid Sans Mono",
      "Courier New", monospace;

    --eden-grey-000: #141b27;
    --eden-grey-100: #1e2737;
    --eden-grey-200: #39465e;
    --eden-grey-300: #74829b;
    --eden-grey-400: #98a8c5;
    --eden-grey-500: #fff9ee;
    --eden-grey-600: #ffffff;
    --eden-grey-gradient: linear-gradient(
      -45deg,
      var(--eden-grey-000),
      var(--eden-grey-100)
    );

    --eden-red-100: #ff6b6b;
    --eden-red-200: #e78482;
    --eden-red-300: #f5b5b5;
    --eden-red-400: #f9d6d6;
    --eden-red-500: #fff5f5;
    --eden-red-gradient: linear-gradient(
      -45deg,
      var(--eden-red-200),
      var(--eden-red-100)
    );

    --eden-green-100: #6fc2b0;
    --eden-green-200: #8fc8bb;
    --eden-green-300: #b3ded5;
    --eden-green-400: #d4f1ed;
    --eden-green-500: #f0fcfb;
    --eden-green-gradient: linear-gradient(
      -45deg,
      var(--eden-green-200),
      var(--eden-green-100)
    );

    --eden-yellow-100: #a68953;
    --eden-yellow-200: #e0b972;
    --eden-yellow-300: #f1dca4;
    --eden-yellow-400: #f4d8a9;
    --eden-yellow-500: #fffaf0;
    --eden-yellow-gradient: linear-gradient(
      -45deg,
      var(--eden-yellow-200),
      var(--eden-yellow-100)
    );

    --eden-orange-100: #ff9a4d;
    --eden-orange-200: #ffb374;
    --eden-orange-300: #ffd4a8;
    --eden-orange-400: #ffe8d1;
    --eden-orange-500: #fffaf5;
    --eden-orange-gradient: linear-gradient(
      -45deg,
      var(--eden-orange-200),
      var(--eden-orange-100)
    );

    --eden-blue-100: #4a9abe;
    --eden-blue-200: #6db3ce;
    --eden-blue-300: #a1d4e6;
    --eden-blue-400: #cae7f2;
    --eden-blue-500: #f0f9fc;
    --eden-blue-gradient: linear-gradient(
      -45deg,
      var(--eden-blue-200),
      var(--eden-blue-100)
    );

    --eden-magenta-100: #9561ba;
    --eden-magenta-200: #ad82cb;
    --eden-magenta-300: #caaede;
    --eden-magenta-400: #e2d5ed;
    --eden-magenta-500: #f8f5fc;
    --eden-magenta-gradient: linear-gradient(
      -45deg,
      var(--eden-magenta-200),
      var(--eden-magenta-100)
    );

    --eden-cyan-100: #1fa9aa;
    --eden-cyan-200: #2fc2c3;
    --eden-cyan-300: #7dd9da;
    --eden-cyan-400: #b8ebe0;
    --eden-cyan-500: #e8faf9;
    --eden-cyan-gradient: linear-gradient(
      -45deg,
      var(--eden-cyan-200),
      var(--eden-cyan-100)
    );

    --eden-red-o-10: #e784821a;
    --eden-red-0-20: #e7848233;
    --eden-red-0-30: #e784824d;
    --eden-red-0-40: #e784824d;
    --eden-red-0-50: #e784825a;
    --eden-red-0-60: #e7848266;
    --eden-red-0-70: #e7848273;
    --eden-red-0-80: #e7848280;
    --eden-red-0-90: #e7848290;

    --eden-green-o-10: #8fc8bb1a;
    --eden-green-o-20: #8fc8bb33;
    --eden-green-o-30: #8fc8bb4d;
    --eden-green-o-40: #8fc8bb66;
    --eden-green-o-50: #8fc8bb80;
    --eden-green-o-60: #8fc8bb99;
    --eden-green-o-70: #8fc8bbb3;
    --eden-green-o-80: #8fc8bbcc;
    --eden-green-o-90: #8fc8bbe6;

    --eden-yellow-o-10: #e0b9721a;
    --eden-yellow-o-20: #e0b97233;
    --eden-yellow-o-30: #e0b9724d;
    --eden-yellow-o-40: #e0b97266;
    --eden-yellow-o-50: #e0b97280;
    --eden-yellow-o-60: #e0b97299;
    --eden-yellow-o-70: #e0b972b3;
    --eden-yellow-o-80: #e0b972cc;
    --eden-yellow-o-90: #e0b972e6;

    --eden-orange-o-10: #ffb3741a;
    --eden-orange-o-20: #ffb37433;
    --eden-orange-o-30: #ffb3744d;
    --eden-orange-o-40: #ffb37466;
    --eden-orange-o-50: #ffb37480;
    --eden-orange-o-60: #ffb37499;
    --eden-orange-o-70: #ffb374b3;
    --eden-orange-o-80: #ffb374cc;
    --eden-orange-o-90: #ffb374e6;

    --eden-blue-o-10: #6db3ce1a;
    --eden-blue-o-20: #6db3ce33;
    --eden-blue-o-30: #6db3ce4d;
    --eden-blue-o-40: #6db3ce66;
    --eden-blue-o-50: #6db3ce80;
    --eden-blue-o-60: #6db3ce99;
    --eden-blue-o-70: #6db3ceb3;
    --eden-blue-o-80: #6db3cecc;
    --eden-blue-o-90: #6db3cee6;

    --eden-magenta-o-10: #ad82cb1a;
    --eden-magenta-o-20: #ad82cb33;
    --eden-magenta-o-30: #ad82cb4d;
    --eden-magenta-o-40: #ad82cb66;
    --eden-magenta-o-50: #ad82cb80;
    --eden-magenta-o-60: #ad82cb99;
    --eden-magenta-o-70: #ad82cbb3;
    --eden-magenta-o-80: #ad82cbcc;
    --eden-magenta-o-90: #ad82cbe6;

    --eden-cyan-o-10: #2fc2c31a;
    --eden-cyan-o-20: #2fc2c333;
    --eden-cyan-o-30: #2fc2c34d;
    --eden-cyan-o-40: #2fc2c366;
    --eden-cyan-o-50: #2fc2c380;
    --eden-cyan-o-60: #2fc2c399;
    --eden-cyan-o-70: #2fc2c3b3;
    --eden-cyan-o-80: #2fc2c3cc;
    --eden-cyan-o-90: #2fc2c3e6;

    --eden-primary-color: var(--eden-magenta-200);
    --eden-secondary-color: var(--eden-magenta-300);
    --eden-light-color: #ffffff;

    --eden-primary-color-o-10: #ad82cb1a;
    --eden-primary-color-o-20: #ad82cb33;
    --eden-primary-color-o-30: #ad82cb4d;
    --eden-primary-color-o-40: #ad82cb66;
    --eden-primary-color-o-50: #ad82cb80;
    --eden-primary-color-o-60: #ad82cb99;
    --eden-primary-color-o-70: #ad82cbb3;
    --eden-primary-color-o-80: #ad82cbcc;
    --eden-primary-color-o-90: #ad82cbe6;

    --eden-shadow-100: 0 5px 10px rgba(0, 0, 0, 0.12);
    --eden-shadow-200: 0 5px 10px rgba(0, 0, 0, 0.24);
    --eden-shadow-300: 0 5px 10px rgba(0, 0, 0, 0.36);
    --eden-shadow-400: 0 5px 10px rgba(0, 0, 0, 0.48);

    --eden-radius-100: 3px;
    --eden-radius-200: 6px;
    --eden-radius-300: 9px;
    --eden-radius-400: 12px;

    --eden-transition-easing: cubic-bezier(0.4, 0, 0.2, 1);

    --eden-main-ui-height: 44px;
  }
`;
export default theme;
