var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenStructureTreeNode_renderTreeNode, _EdenStructureTreeNode_treeClicked, _EdenStructureTreeNode_treeDoubleClicked, _EdenStructureTreeNode_removeHoverClass, _EdenStructureTreeNode_addHoveredClass, _EdenStructureTreeNode_getDroppedPosition, _EdenStructureTreeNode_onDragOver, _EdenStructureTreeNode_onDragStart, _EdenStructureTreeNode_onDrop, _EdenStructureTreeNode_onDragEnd, _EdenStructureTreeNode_caretClicked, _EdenStructureTreeNode_openMountedSource;
import EdenStructureTree from "./eden-structure-tree.js";
import EdenModal from "../common/eden-modal.js";
import { fireEvent } from "../../services/event.js";
import html from "../../services/html.js";
import t from "../../i18n/index.js";
class EdenStructureTreeNode extends HTMLElement {
    constructor({ node, depth, linking, templateToMatch }) {
        super();
        this.hasMounted = false;
        this.disabled = false;
        this.linking = false;
        this.depth = 0;
        this.opened = false;
        _EdenStructureTreeNode_renderTreeNode.set(this, () => {
            if (this.querySelector(".structure-tree__node")) {
                return;
            }
            if (this.nodeId !== undefined) {
                this.setAttribute("data-id", this.nodeId.toString());
            }
            if (this.path) {
                this.setAttribute("data-path", this.path);
            }
            const node = document.createElement("div");
            node.classList.add("structure-tree__node");
            const label = this.linking ? this.label || this.path : this.name;
            const mountedButton = this.hasMounted
                ? html `
          <button
            is="eden-button"
            class="structure-tree__node-leaf-mounted"
            tooltip="${t("structure.anchor-page-tooltip")}"
          >
            <eden-icon
              code="tree"
              class="structure-tree__node-leaf-mounted-icon"
            ></eden-icon>
          </button>
        `
                : "";
            node.innerHTML = html `
      <div class="structure-tree__node-leaf-container">
        <button class="structure-tree__node-leaf">
          <div class="structure-tree__node-leaf-dropzone-before"></div>
          <div class="structure-tree__node-leaf-dropzone-after"></div>
          <div class="structure-tree__node-leaf-dropzone-inside"></div>
          <div class="structure-tree__node-caret">
            <span class="structure-tree__node-caret-inner"></span>
          </div>
          <div class="structure-tree__node-label">${label}</div>
        </button>
        ${mountedButton}
      </div>
    `;
            const subsTree = this.subsNode && this.subsNode.length > 0
                ? new EdenStructureTree({
                    tree: this.subsNode,
                    linking: this.linking,
                    templateToMatch: this.templateToMatch,
                    depth: this.depth + 1,
                })
                : null;
            if (this.disabled) {
                node.classList.add("structure-tree__node--disabled");
            }
            if (subsTree) {
                node.classList.add("structure-tree__node--has-subs");
                node.appendChild(subsTree);
            }
            this.appendChild(node);
        });
        _EdenStructureTreeNode_treeClicked.set(this, (e) => {
            e.stopPropagation();
            if (this.disabled)
                return;
            fireEvent(this, "eden-structure-node-clicked", this);
        });
        _EdenStructureTreeNode_treeDoubleClicked.set(this, (e) => {
            e.stopPropagation();
            const target = e.target;
            const isCaret = target.closest(".structure-tree__node-caret") === this.caret;
            if (this.disabled || isCaret)
                return;
            fireEvent(this, "eden-structure-node-double-clicked", this);
        });
        _EdenStructureTreeNode_removeHoverClass.set(this, () => {
            this.leaf.classList.remove("structure-tree__node-leaf--top");
            this.leaf.classList.remove("structure-tree__node-leaf--in");
            this.leaf.classList.remove("structure-tree__node-leaf--bottom");
        });
        _EdenStructureTreeNode_addHoveredClass.set(this, (y, rect) => {
            __classPrivateFieldGet(this, _EdenStructureTreeNode_removeHoverClass, "f").call(this);
            if (y <= rect.top + 4) {
                this.leaf.classList.add("structure-tree__node-leaf--top");
                return;
            }
            if (y >= rect.bottom - 4) {
                this.leaf.classList.add("structure-tree__node-leaf--bottom");
                return;
            }
            this.leaf.classList.add("structure-tree__node-leaf--in");
        });
        _EdenStructureTreeNode_getDroppedPosition.set(this, () => {
            return this.leaf.classList.contains("structure-tree__node-leaf--bottom")
                ? "BOT"
                : this.leaf.classList.contains("structure-tree__node-leaf--top")
                    ? "TOP"
                    : "IN";
        });
        _EdenStructureTreeNode_onDragOver.set(this, (e) => {
            e.stopPropagation();
            const { draggedNode, hoveredNode } = this.closest("eden-edit-structure");
            if (draggedNode === undefined)
                return;
            const target = e.target;
            if (!target)
                return;
            const leaf = target.closest(".structure-tree__node-leaf");
            if (!leaf)
                return;
            if (!hoveredNode || this.nodeId !== hoveredNode.nodeId) {
                fireEvent(this, "eden-structure-overred-node-changed", this);
                this.hoveredTime = new Date();
            }
            const leafInner = __classPrivateFieldGet(this, _EdenStructureTreeNode_getDroppedPosition, "f").call(this) === "IN";
            if (leafInner) {
                if (this.hoveredTime === undefined) {
                    this.hoveredTime = new Date();
                }
                if (!this.opened && this !== draggedNode) {
                    const endDate = new Date();
                    const timeDiff = endDate.getTime() - this.hoveredTime.getTime();
                    if (timeDiff > 1250) {
                        this.opened = true;
                        this.setAttribute("opened", "");
                    }
                }
            }
            else {
                this.hoveredTime = undefined;
            }
            const isChild = isChildOf(draggedNode, this);
            if (draggedNode === this || isChild) {
                return false;
            }
            e.preventDefault();
            const { hoveredRect } = this.closest("eden-edit-structure");
            __classPrivateFieldGet(this, _EdenStructureTreeNode_addHoveredClass, "f").call(this, e.y, hoveredRect);
        });
        _EdenStructureTreeNode_onDragStart.set(this, (e) => {
            e.stopPropagation();
            fireEvent(this, "eden-structure-dragged-node-changed", this);
            this.setAttribute("dragged", "");
            this.ghost = Object.assign(document.createElement("div"), {
                className: "structure-tree__dragged-ghost",
            });
            const leaf = this.querySelector(".structure-tree__node-leaf");
            if (!leaf)
                return;
            this.ghost.innerHTML = leaf.outerHTML;
            this.appendChild(this.ghost);
            if (e.dataTransfer) {
                e.dataTransfer.setDragImage(this.ghost, 15, 5);
            }
        });
        _EdenStructureTreeNode_onDrop.set(this, (e) => {
            e.preventDefault();
            e.stopPropagation();
            const position = __classPrivateFieldGet(this, _EdenStructureTreeNode_getDroppedPosition, "f").call(this);
            fireEvent(this, "eden-structure-drop-changed", { position });
            __classPrivateFieldGet(this, _EdenStructureTreeNode_removeHoverClass, "f").call(this);
        });
        _EdenStructureTreeNode_onDragEnd.set(this, (e) => {
            e.stopPropagation();
            this.removeAttribute("dragged");
            fireEvent(this, "eden-structure-drag-end", this);
            this.removeChild(this.ghost);
        });
        this.openNode = () => {
            if (this.opened)
                return;
            this.opened = true;
            this.setAttribute("opened", "");
        };
        this.closeNode = () => {
            if (!this.opened)
                return;
            this.opened = false;
            this.removeAttribute("opened");
            this.setAttribute("closing", "");
            setTimeout(() => {
                this.removeAttribute("closing");
            }, 160);
        };
        _EdenStructureTreeNode_caretClicked.set(this, (e) => {
            e.preventDefault();
            e.stopPropagation();
            if (this.opened) {
                this.closeNode();
            }
            else {
                this.openNode();
            }
        });
        _EdenStructureTreeNode_openMountedSource.set(this, async () => {
            if (!this.hasMounted || !this.mountedSource)
                return;
            const result = await fetch(this.mountedSource);
            const json = await result.json();
            const content = JSON.stringify(json, null, 2);
            const styles = `
      margin: -5px 0;
      padding: 10px;
      color: var(--eden-grey-000);
      background-color: var(--eden-grey-600);
      border-radius: var(--eden-radius-200);
      overflow: auto;
    `;
            const modal = new EdenModal({
                icon: "source",
                title: t("modals.source.title"),
                content: html `<pre style="${styles}"><code>${content}</code></pre>`,
                buttons: [{ value: t("common.close"), cssClass: "cancel" }],
            });
            document.body.appendChild(modal);
        });
        const isDisabled = templateToMatch
            ? templateToMatch !== node.template
            : node.disabled;
        this.name = node.name;
        this.label = node.label;
        this.path = node.path;
        this.nodeId = node.id;
        this.subsNode = node.subs;
        this.mountedSource = node.mountedSource;
        this.hasMounted = Boolean(node.mountedSource);
        this.disabled = isDisabled;
        this.linking = linking;
        this.templateToMatch = templateToMatch;
        this.depth = depth || 0;
    }
    connectedCallback() {
        __classPrivateFieldGet(this, _EdenStructureTreeNode_renderTreeNode, "f").call(this);
        this.leaf = this.querySelector(".structure-tree__node-leaf");
        this.caret = this.querySelector(".structure-tree__node-caret");
        this.mountedButton = this.querySelector(".structure-tree__node-leaf-mounted");
        this.leaf.draggable = !this.linking;
        this.leaf.addEventListener("click", __classPrivateFieldGet(this, _EdenStructureTreeNode_treeClicked, "f"));
        this.leaf.addEventListener("dblclick", __classPrivateFieldGet(this, _EdenStructureTreeNode_treeDoubleClicked, "f"));
        this.setAttribute("style", `--structure-tree-node-depth: ${this.depth}`);
        if (!this.linking) {
            this.addEventListener("dragend", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDragEnd, "f"));
            this.addEventListener("dragover", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDragOver, "f"));
            this.addEventListener("drop", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDrop, "f"));
            this.leaf.addEventListener("dragstart", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDragStart, "f"));
        }
        if (this.hasMounted) {
            this.mountedButton.addEventListener("click", __classPrivateFieldGet(this, _EdenStructureTreeNode_openMountedSource, "f"));
        }
        this.caret.addEventListener("click", __classPrivateFieldGet(this, _EdenStructureTreeNode_caretClicked, "f"));
    }
    disconnectedCallback() {
        this.caret.removeEventListener("click", __classPrivateFieldGet(this, _EdenStructureTreeNode_caretClicked, "f"));
        if (this.hasMounted) {
            this.mountedButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenStructureTreeNode_openMountedSource, "f"));
        }
        if (!this.linking) {
            this.leaf.removeEventListener("dragstart", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDragStart, "f"));
            this.removeEventListener("drop", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDrop, "f"));
            this.removeEventListener("dragover", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDragOver, "f"));
            this.removeEventListener("dragend", __classPrivateFieldGet(this, _EdenStructureTreeNode_onDragEnd, "f"));
        }
        this.leaf.removeEventListener("dblclick", __classPrivateFieldGet(this, _EdenStructureTreeNode_treeDoubleClicked, "f"));
        this.leaf.removeEventListener("click", __classPrivateFieldGet(this, _EdenStructureTreeNode_treeClicked, "f"));
    }
}
_EdenStructureTreeNode_renderTreeNode = new WeakMap(), _EdenStructureTreeNode_treeClicked = new WeakMap(), _EdenStructureTreeNode_treeDoubleClicked = new WeakMap(), _EdenStructureTreeNode_removeHoverClass = new WeakMap(), _EdenStructureTreeNode_addHoveredClass = new WeakMap(), _EdenStructureTreeNode_getDroppedPosition = new WeakMap(), _EdenStructureTreeNode_onDragOver = new WeakMap(), _EdenStructureTreeNode_onDragStart = new WeakMap(), _EdenStructureTreeNode_onDrop = new WeakMap(), _EdenStructureTreeNode_onDragEnd = new WeakMap(), _EdenStructureTreeNode_caretClicked = new WeakMap(), _EdenStructureTreeNode_openMountedSource = new WeakMap();
export default EdenStructureTreeNode;
if (!customElements.get("eden-structure-tree-node")) {
    customElements.define("eden-structure-tree-node", EdenStructureTreeNode);
}
function isChildOf(parent, node) {
    const draggedChildren = Array.from(parent.querySelectorAll("eden-structure-tree-node"));
    return draggedChildren.reduce((acc, child) => {
        return acc || child === node;
    }, false);
}
