import type { StructureNode, StructureTree } from "../../types.js";
interface Constructor {
    node: Partial<StructureNode>;
    depth?: number;
    linking?: boolean;
    templateToMatch?: string;
}
export default class EdenStructureTreeNode extends HTMLElement {
    #private;
    name?: string;
    label?: string;
    path?: string;
    nodeId?: number;
    subsNode?: StructureTree[];
    mountedSource?: string | null;
    hasMounted: boolean;
    disabled?: boolean;
    linking?: boolean;
    templateToMatch?: string;
    depth: number;
    opened: boolean;
    caret: HTMLElement;
    leaf: HTMLElement;
    mountedButton: HTMLElement;
    ghost: HTMLElement;
    hoveredTime: Date | undefined;
    constructor({ node, depth, linking, templateToMatch }: Constructor);
    openNode: () => void;
    closeNode: () => void;
    connectedCallback(): void;
    disconnectedCallback(): void;
}
export {};
//# sourceMappingURL=eden-structure-tree-node.d.ts.map