import css from "../../services/css.js";
const styles = css `
  eden-structure-search {
    position: absolute;
    width: 100%;
    height: auto;
    display: flex;
    flex-direction: column;
  }

  eden-structure-search[opened] {
    height: 100%;
  }

  eden-structure-search .edit-structure-search-header {
    position: relative;
  }

  .edit-structure-search-icon {
    position: absolute;
    top: 8px;
    left: 7px;
    width: 16px;
    height: 16px;
    fill: var(--eden-grey-600, #ffffff);
    pointer-events: none;
    z-index: 1;
  }

  .edit-structure-search-icon svg {
    display: block;
  }

  eden-structure-search eden-input .eden-input__input {
    height: 32px;
    padding: 4px 8px 4px 28px;
  }

  .edit-structure-search-close {
    position: absolute;
    top: 4px;
    right: 6px;
    width: 24px;
    height: 24px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-left: auto;
    padding: 0;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-100);
    cursor: pointer;
    user-select: none;
    box-shadow: 0 0 0 1px transparent inset;
    opacity: 0;
    pointer-events: none;
    transition: opacity 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  eden-structure-search[opened] .edit-structure-search-close {
    opacity: 1;
    pointer-events: auto;
  }

  .edit-structure-search-close:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .edit-structure-search-close:hover {
    background-color: var(--eden-grey-100);
  }

  .edit-structure-search-close:focus {
    outline: none;
  }

  .edit-structure-search-close:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .edit-structure-search-close > eden-icon {
    width: 16px;
    height: 16px;
    fill: var(--eden-grey-500);
  }

  .edit-structure-search-results {
    display: none;
  }

  eden-structure-search[opened] .edit-structure-search-results:empty {
    padding: 60px 0;
    align-items: center;
    text-align: center;
  }

  eden-structure-search[opened] .edit-structure-search-results:empty::after {
    content: var(--eden-label-no-results, "Pas de résultat...");
    color: var(--eden-grey-400);
    font-size: 14px;
  }

  eden-structure-search[opened] .edit-structure-search-results {
    flex: 1 1 100%;
    max-height: calc(100% - 47px);
    display: flex;
    flex-direction: column;
    padding: 0;
    border-radius: 0 0 0 var(--eden-radius-200);
    overflow: auto;
    background: linear-gradient(var(--eden-grey-000) 30%, hsla(0, 0%, 100%, 0)),
      linear-gradient(hsla(0, 0%, 100%, 0), var(--eden-grey-000) 70%) 0 100%,
      radial-gradient(farthest-side at 50% 0, rgba(0, 0, 0, 0.1), transparent),
      radial-gradient(
          farthest-side at 50% 100%,
          rgba(0, 0, 0, 0.1),
          transparent
        )
        0 100%;
    background-repeat: no-repeat;
    background-size: 100% 30px, 100% 30px, 100% 10px, 100% 10px;
    background-attachment: local, local, scroll, scroll;
    background-color: var(--eden-grey-000);
    z-index: 1;
  }

  .edit-structure-search-result {
    flex: 0 0 auto;
    min-height: 32px;
    position: relative;
    display: flex;
    align-items: center;
    gap: 10px;
    color: var(--eden-grey-500);
    text-align: left;
    font-family: var(--eden-content-font);
    font-size: 13px;
    background-color: transparent;
    border: 0;
    user-select: none;
    cursor: pointer;
    box-shadow: 0 0 0 1px transparent inset;
    transition: color 160ms var(--eden-transition-easing),
      background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .edit-structure-search-result:not(:disabled):hover {
    background-color: var(--eden-grey-100);
  }

  .edit-structure-search-result:not(:disabled):focus {
    outline: none;
  }

  .edit-structure-search-result:not(:disabled):focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .edit-structure-search-result:not(:disabled):active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .edit-structure-search-result[data-current]:not(:disabled) {
    color: var(--eden-grey-000);
    background-color: var(--eden-primary-color);
  }

  .edit-structure-search-result:disabled {
    filter: grayscale(1) opacity(0.5);
    cursor: not-allowed;
  }
`;
export default styles;
