import { StructureTree } from "../../types.js";
import type EdenInput from "../common/eden-input.js";
import type EdenEditStructure from "./eden-edit-structure.js";
import type EdenStructureTree from "./eden-structure-tree.js";
interface Constructor {
    editStructure: EdenEditStructure | EdenStructureTree;
    structure: StructureTree["structure"];
    label?: "name" | "path";
    templateToMatch?: string;
}
export default class EdenStructureSearch extends HTMLElement {
    #private;
    editStructure: Constructor["editStructure"];
    structure: Constructor["structure"];
    flattenedStructure: Constructor["structure"];
    label: "name" | "path";
    templateToMatch?: string;
    search: string;
    input: EdenInput;
    close: HTMLElement;
    results: HTMLElement;
    constructor({ editStructure: structureTree, structure, label, templateToMatch, }: Constructor);
    connectedCallback(): void;
    disconnectedCallback(): void;
    get opened(): boolean;
    set opened(value: boolean);
}
export {};
//# sourceMappingURL=eden-structure-search.d.ts.map