import css from "../../services/css.js";
import keyShortcutsStyles from "../styles/eden-key-shortcuts-styles.js";
import structureTreeStyles from "../styles/eden-structure-tree-styles.js";
const styles = css `
  eden-edit-structure {
    flex: 1 1 100%;
    display: flex;
  }

  .structure-tree__inner-left {
    flex: 0 0 30%;
    position: relative;
    display: flex;
    flex-direction: column;
  }

  .structure-tree__loader {
    display: none;
  }

  .structure-tree__loader:only-child {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .structure-tree__loader-icon {
    width: 24px;
    height: 24px;
    fill: currentcolor;
    animation: structure-tree-loader-spinning 1280ms
      var(--eden-transition-easing) infinite;
  }

  @keyframes structure-tree-loader-spinning {
    100% {
      transform: rotate(1turn);
    }
  }

  eden-structure-search > .edit-structure-search-header {
    width: 100%;
    display: flex;
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    border-bottom: 1px solid var(--eden-grey-100);
    border-radius: var(--eden-radius-200) 0 0 0;
  }

  eden-structure-search .edit-structure-search-header eden-input input,
  eden-structure-search .edit-structure-search-header eden-input input:focus {
    border: 0;
    border-radius: 0;
  }

  eden-structure-tree-buttons {
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    display: flex;
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    border-top: 1px solid var(--eden-grey-100);
  }

  .structure-tree__button {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    cursor: pointer;
    background-color: var(--eden-grey-100);
    color: var(--eden-grey-500);
    border: 0;
    transition: background-color 160ms var(--eden-transition-easing);
  }

  .structure-tree__button:not(
      [disabled],
      .structure-tree__button--cancel,
      .structure-tree__button--confirm
    ):hover {
    background-color: var(--eden-grey-200);
  }

  .structure-tree__button[hidden] {
    display: none;
  }

  .structure-tree__button[disabled] {
    background-color: var(--eden-grey-300);
    cursor: not-allowed;
    opacity: 0.5;
  }

  .structure-tree__button:focus {
    outline: none;
  }

  .structure-tree__button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .structure-tree__button--rename,
  .structure-tree__button--cancel {
    margin-left: auto;
  }

  .structure-tree__button--cancel,
  .structure-tree__button--confirm {
    color: var(--eden-grey-000);
  }

  .structure-tree__button--cancel {
    background: var(--eden-red-gradient);
  }

  .structure-tree__button--confirm {
    background: var(--eden-green-gradient);
  }

  .structure-tree__button-icon {
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }

  .structure-tree__inner-left > eden-structure-tree {
    position: absolute;
    top: 34px;
    left: 0;
    width: 100%;
    height: calc(100% - (34px * 2));
  }

  ${structureTreeStyles(".structure-tree__inner-left")}

  ${keyShortcutsStyles()}
`;
export default styles;
