import css from "../../services/css.js";
export const pillStyles = css `
  .edit-structure-entry__pill {
    flex: 0 0 6px;
    width: 6px;
    height: 6px;
    margin-left: 7px;
    border-radius: 50%;
    background-color: grey;
  }

  .edit-structure-entry__pill--alert {
    background-color: var(--eden-red-400);
  }

  .edit-structure-entry__pill--warning {
    background-color: var(--eden-yellow-400);
  }

  .edit-structure-entry__pill--ok {
    background-color: var(--eden-green-400);
  }
`;
const styles = css `
  eden-edit-structure-entry {
    display: block;
    height: 100%;
  }

  .edit-structure-entry {
    height: 100%;
    position: relative;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    gap: 10px;
    box-sizing: border-box;
    color: var(--eden-grey-500);
    background-color: var(--eden-grey-000);
  }

  .edit-structure-entry__top {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 10px;
    border-bottom: 1px solid var(--eden-grey-100);
  }

  .edit-structure-entry__tabs,
  .edit-structure-entry__lang-switch {
    height: 33px;
    display: flex;
  }

  .edit-structure-entry__tab,
  .edit-structure-entry__lang {
    flex: 0 0 auto;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 3px 13px;
    box-sizing: border-box;
    font-family: inherit;
    font-size: 15px;
    color: var(--eden-grey-600);
    background-color: transparent;
    border: 0;
    cursor: pointer;
    user-select: none;
    box-shadow: 0 0 0 1px transparent inset;
    transition: color 160ms var(--eden-transition-easing),
      background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .edit-structure-entry__tab:active,
  .edit-structure-entry__lang:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .edit-structure-entry__tab:focus,
  .edit-structure-entry__lang:focus {
    outline: none;
  }

  .edit-structure-entry__tab:focus-visible,
  .edit-structure-entry__lang:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .edit-structure-entry__tab:not(.edit-structure-entry__tab--active):hover,
  .edit-structure-entry__lang:not(.edit-structure-entry__lang--active):hover {
    background-color: var(--eden-grey-100);
  }

  .edit-structure-entry__tab--active,
  .edit-structure-entry__lang--active {
    color: var(--eden-grey-000);
    background-color: var(--eden-primary-color);
    border: 0;
  }

  ${pillStyles}

  .edit-structure-entry__lang-switch {
    height: 100%;
    transition: opacity 160ms, transform 160ms var(--eden-transition-easing);
  }

  .edit-structure-entry__lang-switch--hidden {
    opacity: 0;
    pointer-events: none;
  }

  .edit-structure-entry__lang {
    font-size: 13px;
    font-family: var(--eden-content-font);
  }

  .edit-structure-entry__lang:only-child {
    display: none;
  }

  .edit-structure-entry__forms {
    position: relative;
    padding: 0 10px;
  }

  .edit-structure-entry__form {
    display: none;
    width: 100%;
    flex-direction: column;
    gap: 9px;
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    border-radius: var(--eden-radius-200);
  }

  .edit-structure-entry__form--visible {
    display: flex;
  }

  .edit-structure-entry__group {
    display: flex;
    align-items: center;
    gap: 10px;
  }

  .edit-structure-entry__helper {
    position: relative;
    width: 18px;
    height: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    background-color: transparent;
    border: 0;
  }

  .edit-structure-entry__helper-icon {
    width: 18px;
    height: 18px;
    fill: var(--eden-grey-500);
  }

  .edit-structure-entry__wrapper {
    position: relative;
  }

  [name="url"] .eden-input__input {
    padding-right: 40px;
  }

  .edit-structure-entry__action--copy-url {
    position: absolute;
    bottom: 4px;
    right: 4px;
    width: 26px;
    height: 26px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    color: var(--eden-grey-500);
    background-color: var(--eden-grey-200);
    border: 0;
    border-radius: var(--eden-radius-100);
    cursor: pointer;
    user-select: none;
    transition: color 160ms var(--eden-transition-easing),
      background-color 160ms var(--eden-transition-easing);
  }

  .edit-structure-entry__action--copy-url:hover {
    background-color: var(--eden-grey-300);
  }

  .edit-structure-entry__action--copy-url:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .edit-structure-entry__action--copy-url > eden-icon {
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }

  .edit-structure-entry__description-count-container {
    display: flex;
    align-items: center;
    justify-content: flex-end;
    margin-top: -10px;
    font-size: 12px;
    color: var(--eden-grey-500);
    user-select: none;
  }

  .edit-structure-entry__form hr {
    border: 0;
    border-top: 1px solid rgba(0, 0, 0, 0.15);
  }

  .edit-structure-entry__sitemap {
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    padding: 5px 0;
    box-sizing: border-box;
  }

  .edit-structure-entry__sitemap[hidden] {
    display: none;
  }

  .edit-structure-entry__sitemap-label {
    flex: 0 0 100%;
    font-size: 13px;
    font-weight: 700;
    user-select: none;
  }

  .edit-structure-entry__sitemap > eden-checkbox,
  .edit-structure-entry__sitemap > eden-input {
    margin: 10px !important;
    padding: 0 5px;
    box-sizing: border-box;
  }

  .edit-structure-entry__sitemap > eden-checkbox {
    flex: 0 0 auto;
  }

  .edit-structure-entry__sitemap > eden-input {
    flex: 0 0 auto;
  }

  .edit-structure-entry__sitemap > eden-input[type="select"] {
    align-items: stretch;
  }

  .edit-structure-entry__sitemap .eden-input__input--select {
    width: 100%;
  }

  .edit-structure-entry__buttons {
    flex: 0 0 auto;
    display: flex;
    justify-content: flex-end;
    margin-top: auto;
    border-top: 1px solid var(--eden-grey-100);
  }

  .edit-structure-entry__button {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 10px 15px;
    font-size: 16px;
    text-decoration: none;
    font-weight: 700;
    font-family: inherit;
    color: var(--eden-secondary-color);
    background-color: var(--eden-light-color);
    border: 0;
    user-select: none;
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing);
  }

  .edit-structure-entry__button.edit-structure-entry__button--confirm {
    color: var(--eden-green-000);
    background: var(--eden-green-gradient);
  }

  .edit-structure-entry__button:disabled {
    cursor: not-allowed;
    opacity: 0.5;
    filter: grayscale(100%);
  }

  .edit-structure-entry__button-icon {
    display: none;
    flex: 0 0 18px;
    width: 18px;
    height: 18px;
    fill: currentcolor;
  }

  .edit-structure-entry:focus-within
    .edit-structure-entry__button:not(:disabled)
    .edit-structure-entry__button-icon {
    display: block;
  }
`;
export default styles;
