import type { StructureEntryData, StructureLayout } from "../../types.js";
import type EdenInput from "../common/eden-input.js";
import EdenCheckbox from "../common/eden-checkbox.js";
import type EdenTagManager from "../common/eden-tag-manager.js";
export default class EdenEditStructureEntry extends HTMLElement {
    #private;
    isSuperAdmin: boolean;
    unsavedChanges: boolean;
    oldPaths: {
        lang: string;
        path: string;
    }[];
    currentLang: string;
    entryData: StructureEntryData;
    pageTemplate: string;
    urlInput: HTMLInputElement;
    tabs: HTMLElement;
    forms: HTMLElement;
    langSwitch: HTMLElement;
    SEOTabPill: HTMLElement;
    SEOTitle: HTMLInputElement;
    SEODescription: HTMLInputElement;
    SEOTitlePill: HTMLElement;
    SEODescriptionPill: HTMLElement;
    SEODescriptionCount: HTMLElement;
    SEODescriptionCountMax: HTMLElement;
    metadataFields: NodeListOf<EdenInput | EdenCheckbox | EdenTagManager>;
    copyUrlButton: HTMLElement;
    saveButton: HTMLButtonElement;
    saveButtonHtml: string;
    inputs: HTMLElement[];
    observer: MutationObserver;
    constructor(templates: StructureLayout[]);
    saveNode: (e?: Event) => Promise<void>;
    connectedCallback(): void;
    disconnectedCallback(): void;
    static get observedAttributes(): string[];
    attributeChangedCallback(name: string): void;
}
//# sourceMappingURL=eden-edit-structure-entry.d.ts.map