import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
export default class YoutubePlaylistModal {
    constructor(onChange, url) {
        this.onClick = () => {
            const root = this.modal.shadowRoot;
            const field = root.querySelector("[name=url]");
            const url = field.value;
            this.onChange(url);
        };
        this.onChange = onChange;
        this.modal = new EdenModal({
            icon: "movie",
            title: t("modals.youtube-playlist.title"),
            content: template(url),
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                { value: t("common.add"), onClick: this.onClick, cssClass: "confirm" },
            ],
        });
        document.body.append(this.modal);
    }
}
function template(url) {
    return html `
    <style>
      .modal__form {
        width: 450px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
        padding: 10px 0;
        box-sizing: border-box;
      }

      .modal__information {
        font-size: 13px;
        padding: 5px 0;
        color: var(--eden-grey-500);
      }

      .modal__helper {
        padding: 5px 0;
        font-size: 12px;
        font-style: italic;
      }
    </style>
    <div class="modal__form">
      <eden-input
        type="text"
        label="${t("modals.youtube-playlist.link")}"
        name="url"
        value="${url || ""}"
      ></eden-input>
      <div class="modal__information">
        ${t("modals.youtube-playlist.copy-code")}<br />
      </div>
      <div class="modal__helper">
        ${t("modals.youtube-playlist.instructions")}
        "src='<b>https://www.youtube.com/embed/videoseries?list=DDMMMLLPPKKEEAA-Esqdu</b>'
      </div>
    </div>
  `;
}
