import EdenModal from "../common/eden-modal.js";
import type EdenStructureTreeNode from "../structure/eden-structure-tree-node.js";
type Url = string | Record<string, string>;
type OnChange = (url: Url) => void;
interface Constructor {
    onChange: OnChange;
    templateToMatch?: string;
    returnAllBarePaths?: boolean;
}
export default class LinkFromStructureModal {
    onChange: OnChange;
    templateToMatch?: string;
    returnAllBarePaths?: boolean;
    url: Url;
    modal: EdenModal;
    selectedEntry: EdenStructureTreeNode;
    constructor({ onChange, templateToMatch, returnAllBarePaths }: Constructor);
    init: () => Promise<void>;
    nodeClicked: (e: Event) => Promise<void>;
    confirm: () => void;
    closeModal: () => void;
}
export {};
//# sourceMappingURL=link-from-structure-modal.d.ts.map