import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
export default class ImageSettingsModal {
    constructor(onChange, description = "", credits, loading) {
        this.onClick = () => {
            const root = this.modal.shadowRoot;
            const descriptionInput = root.querySelector('[name="description"]');
            const description = descriptionInput.value;
            const creditsInput = root.querySelector('[name="credits"]');
            const credits = creditsInput?.value || "";
            const lazyLoadingCheckbox = root.querySelector('[name="loading"]');
            const lazyLoading = lazyLoadingCheckbox?.checked ?? false;
            const loading = lazyLoading ? "lazy" : "eager";
            this.onChange(description, credits, loading);
        };
        this.onChange = onChange;
        this.description = description;
        this.credits = credits;
        this.loading = loading;
    }
    init() {
        this.modal = new EdenModal({
            icon: "tune",
            title: t("modals.image-settings.title"),
            content: template(this.description, this.credits, this.loading),
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                {
                    value: t("common.validate"),
                    onClick: this.onClick,
                    cssClass: "confirm",
                    autofocus: true,
                },
            ],
        });
        document.body.append(this.modal);
    }
}
function template(description, credits, loading) {
    const hideCredits = credits === undefined;
    const hideLoadingAttribute = loading === undefined;
    return html `
    <style>
      .modal__form {
        width: 420px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
        padding: 10px 0;
        box-sizing: border-box;
      }

      .modal__helper {
        display: flex;
        gap: 10px;
        padding: 10px;
        background-color: var(--eden-grey-100);
        border-radius: var(--eden-radius-200);
      }

      .modal__helper-icon {
        flex: 0 0 26px;
        height: 26px;
        fill: var(--eden-grey-500);
      }

      .modal__helper-text {
        font-size: 13px;
      }
    </style>
    <div class="modal__form">
      <eden-input
        type="text"
        label="${t("modals.image-settings.description")}"
        name="description"
        value="${description}"
      ></eden-input>
      ${renderCreditsInput(credits, hideCredits)}
      ${renderLoadingCheckbox(loading, hideLoadingAttribute)}
      ${renderLoadingHelper(hideLoadingAttribute)}
    </div>
  `;
}
function renderCreditsInput(credits, hideCredits) {
    if (hideCredits)
        return "";
    return html `
    <eden-input
      type="text"
      label="${t("modals.image-settings.credits")}"
      name="credits"
      value="${credits || ""}"
    ></eden-input>
  `;
}
function renderLoadingCheckbox(loading, hideLoadingAttribute) {
    if (hideLoadingAttribute)
        return "";
    return html `
    <eden-checkbox
      label="${t("modals.image-settings.lazy-loading")}"
      name="loading"
      checked="${loading || false}"
    ></eden-checkbox>
  `;
}
function renderLoadingHelper(hideLoadingAttribute) {
    if (hideLoadingAttribute)
        return "";
    return html `
    <div class="modal__helper">
      <eden-icon code="information" class="modal__helper-icon"></eden-icon>
      <div class="modal__helper-text">
        ${t("modals.image-settings.lazy-loading-helper")}
        <br />
        <b
          >${t("modals.image-settings.lazy-loading-warning")}</b
        >
      </div>
    </div>
  `;
}
