import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
export default class IframeModal {
    constructor(onChange, url, width, height, allowFullscreen) {
        this.onClick = () => {
            const root = this.modal.shadowRoot;
            const urlInput = root.querySelector('[name="url"]');
            const url = urlInput.value;
            const widthInput = root.querySelector('[name="width"]');
            const width = widthInput.value;
            const heightInput = root.querySelector('[name="height"]');
            const height = heightInput.value;
            const allowFullscreenCheckbox = root.querySelector('[name="allowFullscreen"]');
            const allowFullscreen = allowFullscreenCheckbox.checked;
            this.onChange(url, width, height, allowFullscreen);
        };
        this.onChange = onChange;
        this.modal = new EdenModal({
            title: t("modals.iframe.title"),
            content: template(url, width, height, allowFullscreen),
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                { value: t("common.add"), onClick: this.onClick, cssClass: "confirm" },
            ],
        });
        document.body.append(this.modal);
    }
}
function template(url = "", width = "1000", height = "450", allowFullscreen) {
    return html `
    <style>
      .modal__form {
        width: 450px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
        padding: 10px 0;
        box-sizing: border-box;
      }
    </style>
    <div class="modal__form">
      <eden-input
        type="text"
        label="${t("modals.iframe.url")}"
        name="url"
        value="${url}"
      ></eden-input>
      <eden-input
        type="text"
        label="${t("modals.iframe.width")}"
        name="width"
        value="${width}"
      ></eden-input>
      <eden-input
        type="text"
        label="${t("modals.iframe.height")}"
        name="height"
        value="${height}"
      ></eden-input>
      <eden-checkbox
        label="${t("modals.iframe.allow-fullscreen")}"
        name="allowFullscreen"
        checked="${allowFullscreen}"
      ></eden-checkbox>
    </div>
  `;
}
