import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
const confirm = ".modal__button--confirm";
const disabled = "modal__button--disabled";
const error = ".modal__error";
const visible = "modal__error--visible";
export default class GoogleMapsModal {
    constructor(onChange, url, width, height) {
        this.getParam = (url, param) => {
            if (url === "")
                return "";
            const search = new URL(url).search;
            const searchParams = new URLSearchParams(search);
            return searchParams.get(param);
        };
        this.checkPlace = () => {
            const root = this.modal.shadowRoot;
            const placeInput = root.querySelector('[name="place"]');
            const place = placeInput.value.trim();
            const valid = place !== "";
            const confirmButton = root.querySelector(confirm);
            const errorContainer = root.querySelector(error);
            if (valid) {
                confirmButton.classList.remove(disabled);
                errorContainer.classList.remove(visible);
            }
            else {
                confirmButton.classList.add(disabled);
                errorContainer.classList.add(visible);
            }
        };
        this.buildUrl = (place, zoom, satelliteView) => {
            const z = zoom === "" ? "10" : zoom;
            const kind = satelliteView ? "k" : "m";
            return `https://maps.google.com/maps?q=${place}&t=${kind}&z=${z}&ie=UTF8&iwloc=&output=embed`;
        };
        this.onClick = () => {
            const root = this.modal.shadowRoot;
            const placeInput = root.querySelector('[name="place"]');
            const place = encodeURI(placeInput.value);
            const zoomInput = root.querySelector('[name="zoom"]');
            const zoom = zoomInput.value;
            const widthInput = root.querySelector('[name="width"]');
            const width = widthInput.value;
            const heightInput = root.querySelector('[name="height"]');
            const height = heightInput.value;
            const satelliteViewCheckbox = root.querySelector('[name="satelliteView"]');
            const satelliteView = satelliteViewCheckbox.checked;
            const url = this.buildUrl(place, zoom, satelliteView);
            this.onChange(url, width, height);
        };
        this.onChange = onChange;
        this.url = url;
        this.place = decodeURI(this.getParam(this.url, "q") || "");
        this.zoom = this.getParam(this.url, "z") || "10";
        this.satelliteView = this.getParam(this.url, "t") === "k";
        this.modal = new EdenModal({
            icon: "map",
            title: t("modals.google-maps.title"),
            content: template(width, height, this.place, this.zoom, this.satelliteView),
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                { value: t("common.add"), onClick: this.onClick, cssClass: "confirm" },
            ],
        });
        document.body.append(this.modal);
        const root = this.modal.shadowRoot;
        if (this.url === "") {
            const confirmButton = root.querySelector(confirm);
            confirmButton.classList.add(disabled);
            const errorContainer = root.querySelector(error);
            errorContainer.classList.add(visible);
        }
        const placeInput = root.querySelector('[name="place"]');
        placeInput.addEventListener("input", this.checkPlace);
        this.getParam = this.getParam.bind(this);
    }
}
function template(width, height, place, zoom, satelliteView) {
    return html `
    <style>
      .modal__form {
        width: 450px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
        padding: 10px 0;
        box-sizing: border-box;
      }

      .modal__error {
        margin: -10px 0;
        padding-top: 3px;
        color: var(--eden-red-400);
        font-size: 12px;
        opacity: 0;
        pointer-events: none;
      }

      .modal__error--visible {
        opacity: 1;
      }

      .modal__information {
        font-size: 13px;
        padding: 5px 0;
        color: var(--eden-grey-500);
      }

      .modal__checkbox {
        margin-top: 22px;
      }
    </style>
    <div class="modal__form">
      <eden-input
        type="text"
        label="${t("modals.google-maps.width")}"
        name="width"
        value="${width || 1000}"
      ></eden-input>
      <eden-input
        type="text"
        label="${t("modals.google-maps.height")}"
        name="height"
        value="${height || 450}"
      ></eden-input>
      <eden-checkbox
        class="modal__checkbox"
        label="${t("modals.google-maps.satellite-view")}"
        name="satelliteView"
        checked="${satelliteView}"
      ></eden-checkbox>
      <eden-input
        type="text"
        label="${t("modals.google-maps.zoom-level")}"
        name="zoom"
        value="${zoom || 10}"
      ></eden-input>
      <div class="modal__information">
        Indiquez un nombre compris entre 0 et 22 (plus ce nombre est élevé, plus
        le niveau de zoom sera important).<br />
      </div>
      <eden-input
        type="text"
        label="${t("modals.google-maps.location")}"
        name="place"
        value="${place || ""}"
      ></eden-input>
      <div class="modal__error">La localisation ne peut pas être vide.</div>
    </div>
  `;
}
