import EdenModal from "../common/eden-modal.js";
import EdenEditStructure from "../structure/eden-edit-structure.js";
import { sendRevalidateAllBeacon } from "../../services/fetcher.js";
import t from "../../i18n/index.js";
export default class EditStructureModal {
    constructor() {
        this.onClose = async () => {
            if (window.sessionStorage.getItem("eden_revalidation_needed")) {
                sendRevalidateAllBeacon();
                window.sessionStorage.removeItem("eden_revalidation_needed");
            }
        };
    }
    init() {
        this.modal = new EdenModal({
            icon: "tree",
            title: t("structure.title"),
            width: 900,
            height: 550,
            content: new EdenEditStructure(),
            onClose: this.onClose,
            noPadding: true,
        });
        document.body.append(this.modal);
    }
}
