import template from "./eden-revalidation-indicator.template.js";
import styles from "./eden-revalidation-indicator.styles.js";
export default class EdenRevalidationIndicator extends HTMLElement {
    constructor() {
        super();
        this.init = () => {
            const existingIndicator = document.querySelector("eden-revalidation-indicator");
            if (existingIndicator) {
                existingIndicator.remove();
            }
            this.setAttribute("loading", "");
            document.body.appendChild(this);
            setTimeout(() => {
                this?.done();
            }, 30000);
        };
        this.done = () => {
            this.removeAttribute("loading");
            this.setAttribute("done", "");
            setTimeout(() => {
                this?.setAttribute("closing", "");
                setTimeout(() => {
                    this?.remove();
                }, 320);
            }, 3000);
        };
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template();
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() { }
    disconnectedCallback() { }
}
if (!customElements.get("eden-revalidation-indicator")) {
    customElements.define("eden-revalidation-indicator", EdenRevalidationIndicator);
}
