import css from "../../services/css.js";
const styles = css `
  :host {
    --height: 3px;

    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: var(--height);
    transition: transform 640ms var(--eden-transition-easing);
    pointer-events: none;
  }

  .player-name {
    position: absolute;
    left: 10px;
    bottom: calc(100% - var(--height));
    padding: 2px 6px;
    font-family: var(--eden-content-font);
    font-size: 14px;
    font-weight: 500;
    color: var(--eden-grey-500);
    background-color: var(--player-color, var(--eden-grey-200));
    border-radius: var(--eden-radius-200) var(--eden-radius-200) 0 0;
  }

  .bar {
    width: 100%;
    height: 100%;
    background-color: var(--player-color, var(--eden-grey-200));
    border-radius: 3px;
  }
`;
export default styles;
