var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenPlayerIndicator_instances, _EdenPlayerIndicator_render;
import html from "../../services/html";
import styles from "./eden-player-indicator.styles.js";
class EdenPlayerIndicator extends HTMLElement {
    constructor({ clientId, firstName, lastName, position }) {
        super();
        _EdenPlayerIndicator_instances.add(this);
        this.clientId = clientId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.position = position;
        this.attachShadow({ mode: "open" });
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    updatePosition(percentage) {
        this.position = percentage;
        const pixelPosition = Math.round((percentage / 100) * document.documentElement.scrollHeight);
        this.style.setProperty("transform", `translateY(${pixelPosition}px)`);
    }
    connectedCallback() {
        this.setAttribute("data-client-id", this.clientId);
        __classPrivateFieldGet(this, _EdenPlayerIndicator_instances, "m", _EdenPlayerIndicator_render).call(this);
        this.updatePosition(this.position);
    }
    disconnectedCallback() { }
}
_EdenPlayerIndicator_instances = new WeakSet(), _EdenPlayerIndicator_render = function _EdenPlayerIndicator_render() {
    this.shadowRoot.innerHTML = html `
      <div class="player-name">${this.firstName} ${this.lastName}</div>
      <div class="bar"></div>
    `;
};
export default EdenPlayerIndicator;
if (!customElements.get("eden-player-indicator")) {
    customElements.define("eden-player-indicator", EdenPlayerIndicator);
}
