import css from "../../services/css.js";
const styles = css `
  eden-page-duplication-ui {
    flex: 1 1 auto;
    display: flex;
  }

  .duplication-form {
    width: 100%;
  }

  .duplication-form__inner {
    display: flex;
    flex-direction: column;
    gap: 14px;
    padding: 10px;
  }

  .duplication-form__page-path {
    flex: 1 1 auto;
    width: auto;
  }

  .duplication-form__selector {
    display: flex;
    align-items: flex-end;
    flex-wrap: wrap;
  }

  .duplication-form__page-button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .duplication-form__selector eden-input[type="select"][hidden] {
    display: none !important;
  }

  .duplication-form__selector input {
    border-right: 0;
    border-radius: var(--eden-radius-200) 0 0 var(--eden-radius-200);
  }

  .duplication-form__selector .duplication-form__button {
    height: 34px;
  }

  .duplication-form__information,
  .duplication-form__warning {
    display: flex;
    align-items: center;
    gap: 5px;
  }

  .duplication-form__information {
    margin-top: -5px;
    color: var(--eden-grey-500);
  }

  .duplication-form__warning {
    gap: 10px;
    color: var(--eden-red-400);
    padding: 10px;
    border-radius: var(--eden-radius-200);
    background-color: var(--eden-grey-100);
  }

  .duplication-form__information-icon,
  .duplication-form__warning-icon {
    flex: 0 0 26px;
    height: 26px;
    fill: currentcolor;
  }

  .duplication-form__information-icon {
    flex: 0 0 18px;
    width: 18px;
    height: 18px;
  }

  .duplication-form__warning-icon {
    flex: 0 0 26px;
    width: 26px;
    height: 26px;
  }

  .duplication-form__information-text,
  .duplication-form__warning-text {
    font-size: 13px;
    font-weight: 400;
  }

  .duplication-form__buttons {
    display: flex;
    align-items: center;
    justify-content: flex-end;
    background: var(--eden-grey-gradient);
    border-top: 1px solid;
    border-image: linear-gradient(
        to right,
        var(--eden-grey-200) 0%,
        var(--eden-grey-100) 100%
      )
      1;
  }

  .duplication-form__button {
    flex: 0 1 auto;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 12px 15px;
    font-size: 16px;
    text-decoration: none;
    font-weight: 700;
    font-family: inherit;
    color: var(--eden-grey-100);
    background-color: var(--eden-primary-color);
    border: 0;
    box-shadow: 0 0 0 1px transparent inset;
    user-select: none;
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .duplication-form__button:hover {
    background-color: var(--eden-secondary-color);
  }

  .duplication-form__button--edit-path {
    border-radius: 0 var(--eden-radius-200) var(--eden-radius-200) 0;
  }

  .duplication-form__button--cancel {
    color: var(--eden-grey-600);
    background-color: var(--eden-grey-100);
  }

  .duplication-form__button--cancel:hover {
    background-color: var(--eden-grey-200);
  }

  .duplication-form__button--confirm {
    color: var(--eden-grey-000);
    background-color: var(--eden-primary-color);
  }

  .duplication-form__button--confirm:not(:disabled):hover {
    background-color: var(--eden-secondary-color);
  }

  .duplication-form__button:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .duplication-form__button:disabled {
    filter: grayscale(100%) opacity(25%);
    cursor: not-allowed;
  }

  .duplication-form__button:focus {
    outline: none;
  }

  .duplication-form__button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .duplication-form__checkbox {
    margin-inline: 10px auto;
  }
`;
export default styles;
export const confirmModalStyles = css `
  .confirm-modal {
    width: 100%;
    max-width: 420px;
    line-height: 1.65;
  }

  .confirm-modal span {
    padding: 2px 5px;
    font-weight: bold;
    font-family: var(--eden-content-font);
    font-size: 14px;
    font-weight: 700;
    background-color: var(--eden-grey-100);
    border-radius: var(--eden-radius-100);
  }
`;
