var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenPageDuplicationUi_getCurrentPath, _EdenPageDuplicationUi_openLinkSelector, _EdenPageDuplicationUi_onLinkSelection, _EdenPageDuplicationUi_cancelDuplication, _EdenPageDuplicationUi_getSelectedLang, _EdenPageDuplicationUi_confirmDuplication, _EdenPageDuplicationUi_startLoading, _EdenPageDuplicationUi_stopLoading, _EdenPageDuplicationUi_showConfirmModal;
import styles, { confirmModalStyles, } from "./eden-page-duplication-ui.styles.js";
import template, { confirmModalTemplate, } from "./eden-page-duplication-ui.template.js";
import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
class EdenPageDuplicationUi extends HTMLElement {
    constructor(callback) {
        super();
        _EdenPageDuplicationUi_getCurrentPath.set(this, () => {
            const { lang, langPrefix } = window.EdenConfig;
            const { pathname } = window.location;
            const barePath = pathname === "/" ? "/" : pathname.replace(/\/$/, "");
            const path = langPrefix ? barePath.replace(`/${lang}/`, "/") : barePath;
            return path;
        });
        _EdenPageDuplicationUi_openLinkSelector.set(this, async () => {
            const { default: LinkFromStructureModal } = await import("../plugin/link-from-structure-modal.js");
            const modal = new LinkFromStructureModal({
                onChange: __classPrivateFieldGet(this, _EdenPageDuplicationUi_onLinkSelection, "f"),
                templateToMatch: window.EdenConfig.layout,
                returnAllBarePaths: true,
            });
            modal.init();
        });
        _EdenPageDuplicationUi_onLinkSelection.set(this, (paths) => {
            const { langs } = window.EdenConfig;
            const castedPaths = paths;
            const path = castedPaths[langs[0]];
            this.pathInput.setAttribute("value", path);
            this.selectedPaths = castedPaths;
            this.pathButton.innerHTML = t("common.modify");
            this.confirmButton.removeAttribute("disabled");
        });
        _EdenPageDuplicationUi_cancelDuplication.set(this, () => {
            this.modal.close();
        });
        _EdenPageDuplicationUi_getSelectedLang.set(this, () => {
            return this.langSelector.getAttribute("value") || "";
        });
        _EdenPageDuplicationUi_confirmDuplication.set(this, async () => {
            const { domains, lang: currentLang } = window.EdenConfig;
            const lang = __classPrivateFieldGet(this, _EdenPageDuplicationUi_getSelectedLang, "f").call(this);
            const ignoreFixedZones = currentLang !== lang;
            const selectedPath = this.selectedPaths[lang];
            __classPrivateFieldGet(this, _EdenPageDuplicationUi_startLoading, "f").call(this);
            await this.callback(lang, selectedPath, ignoreFixedZones);
            __classPrivateFieldGet(this, _EdenPageDuplicationUi_stopLoading, "f").call(this);
            this.modal.close();
            if (this.goToPageCheckbox.getAttribute("checked") === "true") {
                const endpoint = `https://${domains[lang]}${selectedPath}`;
                window.location.href = endpoint;
            }
        });
        _EdenPageDuplicationUi_startLoading.set(this, () => {
            this.confirmButton.setAttribute("disabled", "");
            this.confirmButtonHtml = this.confirmButton.innerHTML;
            this.confirmButton.style.width = `${this.confirmButton.offsetWidth}px`;
            this.confirmButton.style.height = `${this.confirmButton.offsetHeight}px`;
            this.confirmButton.classList.add("spin");
            this.confirmButton.innerHTML = html `<eden-icon
      code="loader"
      class="spinner"
    ></eden-icon>`;
        });
        _EdenPageDuplicationUi_stopLoading.set(this, () => {
            this.confirmButton.removeAttribute("disabled");
            this.confirmButton.innerHTML = this.confirmButtonHtml;
            this.confirmButton.classList.remove("spin");
        });
        _EdenPageDuplicationUi_showConfirmModal.set(this, () => {
            const lang = __classPrivateFieldGet(this, _EdenPageDuplicationUi_getSelectedLang, "f").call(this);
            const selectedPath = this.selectedPaths[lang];
            const confirmModal = new EdenModal({
                icon: "copy_page",
                title: t("page.duplicate-title"),
                content: html `
        <style>
          ${confirmModalStyles}
        </style>
        ${confirmModalTemplate(this.currentPath, selectedPath, lang)}
      `,
                buttons: [
                    {
                        value: t("common.back"),
                        cssClass: "cancel",
                    },
                    {
                        value: t("common.duplicate"),
                        cssClass: "confirm",
                        onClick: __classPrivateFieldGet(this, _EdenPageDuplicationUi_confirmDuplication, "f"),
                    },
                ],
            });
            document.body.appendChild(confirmModal);
        });
        this.callback = callback;
        this.currentPath = __classPrivateFieldGet(this, _EdenPageDuplicationUi_getCurrentPath, "f").call(this);
        this.selectedPaths = {};
        this.innerHTML = html `
      <style>
        ${styles}
      </style>
      ${template(this.currentPath)}
    `;
    }
    async connectedCallback() {
        const shadowRoot = this.getRootNode();
        this.modal = shadowRoot.host;
        this.langSelector = this.querySelector(".duplication-form__lang-selector");
        this.ignoreFixedZonesCheckbox = this.querySelector(".duplication-form__ignore-fixed-zones");
        this.pathInput = this.querySelector(".duplication-form__page-path");
        this.pathButton = this.querySelector(".duplication-form__button--edit-path");
        this.goToPageCheckbox = this.querySelector(".duplication-form__checkbox");
        this.cancelButton = this.querySelector(".duplication-form__button--cancel");
        this.confirmButton = this.querySelector(".duplication-form__button--confirm");
        this.pathButton.addEventListener("click", __classPrivateFieldGet(this, _EdenPageDuplicationUi_openLinkSelector, "f"));
        this.cancelButton.addEventListener("click", __classPrivateFieldGet(this, _EdenPageDuplicationUi_cancelDuplication, "f"));
        this.confirmButton.addEventListener("click", __classPrivateFieldGet(this, _EdenPageDuplicationUi_showConfirmModal, "f"));
    }
    disconnectedCallback() {
        this.confirmButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenPageDuplicationUi_showConfirmModal, "f"));
        this.cancelButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenPageDuplicationUi_cancelDuplication, "f"));
        this.pathButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenPageDuplicationUi_openLinkSelector, "f"));
    }
}
_EdenPageDuplicationUi_getCurrentPath = new WeakMap(), _EdenPageDuplicationUi_openLinkSelector = new WeakMap(), _EdenPageDuplicationUi_onLinkSelection = new WeakMap(), _EdenPageDuplicationUi_cancelDuplication = new WeakMap(), _EdenPageDuplicationUi_getSelectedLang = new WeakMap(), _EdenPageDuplicationUi_confirmDuplication = new WeakMap(), _EdenPageDuplicationUi_startLoading = new WeakMap(), _EdenPageDuplicationUi_stopLoading = new WeakMap(), _EdenPageDuplicationUi_showConfirmModal = new WeakMap();
export default EdenPageDuplicationUi;
if (!customElements.get("eden-page-duplication-ui")) {
    customElements.define("eden-page-duplication-ui", EdenPageDuplicationUi);
}
