import edenLogo from "../common/eden-logo.js";
import { generateShortcut } from "../../services/keys.js";
import html from "../../services/html.js";
import t from "../../i18n/index.js";
export default function template({ firstName, isEditor, isAdmin, lastUpdated, lastUpdatedBy, }) {
    const logoutButtonTooltip = `${t("page.logout")} ${generateShortcut("shift", t("common.escape"))}`;
    const editButtonTooltip = isEditor
        ? `${t("page.activate-edit-mode")} ${generateShortcut("ctrl", "e")}`
        : t("page.no-edit-rights");
    const cancelButtonTooltip = `${t("page.deactivate-edit-mode")} ${generateShortcut("ctrl", "e")}`;
    const previewButtonTooltip = `${t("page.preview-page")} ${generateShortcut("ctrl", "p")}`;
    const saveButtonTooltip = `${t("page.save-changes")} ${generateShortcut("ctrl", "s")}`;
    const structureButtonTooltip = `${t("page.edit-site-structure")} ${generateShortcut("ctrl", "shift", "E")}`;
    let infoButtonTooltip = `${t("page.view-info")} ${generateShortcut("ctrl", "shift", "I")}`;
    if (lastUpdated && lastUpdatedBy) {
        const formatedUpdated = new Date(lastUpdated).toLocaleString("fr-FR");
        infoButtonTooltip = `${t("page.updated-by")} <b>${lastUpdatedBy}</b>
    <br/>
    ${t("page.updated-at")} <b>${formatedUpdated}</b>
    <br/>
    <div style='margin-top: 5px'>${t("page.view-info")} ${generateShortcut("ctrl", "shift", "I")}</div>`;
    }
    const filemanagerButtonTooltip = `${t("page.open-file-manager")} ${generateShortcut("ctrl", "o")}`;
    const structureButton = isAdmin
        ? html ` <button
        is="eden-button"
        tooltip="${structureButtonTooltip}"
        direction="top"
        class="button button--edit-structure"
      >
        <eden-icon code="tree" class="button__icon"></eden-icon>
      </button>`
        : "";
    const refreshButton = isAdmin
        ? html ` <button
        is="eden-button"
        tooltip="${t("page.regenerate-site")}"
        direction="top"
        class="button button--refresh"
      >
        <eden-icon code="refresh" class="button__icon"></eden-icon>
      </button>`
        : "";
    const editButtonDisabledAttribute = !isEditor ? "disabled" : "";
    return html `
    <div class="welcome">
      ${edenLogo}
      <span class="welcome__message">${getWelcomeMessage()}</span>
      <span class="welcome__name">${firstName}</span>
    </div>
    <div class="players"></div>
    <div class="actions">
      <button
        is="eden-button"
        tooltip="${logoutButtonTooltip}"
        class="button button--logout"
      >
        <eden-icon code="power" class="button__icon"></eden-icon>
      </button>
      <div class="button-separator"></div>
      <button
        is="eden-button"
        tooltip="${filemanagerButtonTooltip}"
        class="button button--file-manager"
      >
        <eden-icon code="folder_image" class="button__icon"></eden-icon>
      </button>
      ${refreshButton} ${structureButton}
      <div class="button-separator"></div>
      <button
        is="eden-button"
        tooltip="${previewButtonTooltip}"
        class="button button--preview"
      >
        <eden-icon code="eye" class="button__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="button button--duplicate"
        tooltip="${t("page.duplicate-to")}"
      >
        <eden-icon code="copy_page" class="button__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="button button--info"
        tooltip="${infoButtonTooltip}"
        direction="top-left"
      >
        <eden-icon code="information_card" class="button__icon"></eden-icon>
      </button>
      <div class="button-separator"></div>
      <button
        is="eden-button"
        class="button button--cancel"
        tooltip="${cancelButtonTooltip}"
        direction="top-left"
      >
        <eden-icon code="close" class="button__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="button button--save"
        tooltip="${saveButtonTooltip}"
        direction="top-left"
      >
        <eden-icon code="floppy_disk" class="button__icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="button button--edit"
        ${editButtonDisabledAttribute}
        tooltip="${editButtonTooltip}"
        direction="top-left"
      >
        <eden-icon code="edit_pen" class="button__icon"></eden-icon>
      </button>
    </div>
  `;
}
function getWelcomeMessage() {
    const now = new Date();
    const hours = now.getHours();
    let message = t("page.morning");
    if (hours < 12) {
        message = t("page.morning");
    }
    else if (hours < 18) {
        message = t("page.afternoon");
    }
    else {
        message = t("page.evening");
    }
    return message;
}
