import html from "../../services/html";
export function renderIcon(paths) {
    return html ` <svg viewBox="0 0 24 24">${renderIconPaths(paths)}</svg> `;
}
function renderIconPaths(paths) {
    return paths
        .map((path) => {
        if (typeof path === "string") {
            return html `<path d="${path}" />`;
        }
        else {
            const { path: svgPath, ...props } = path;
            let attributes = "";
            if (Object.keys(props).length > 0) {
                attributes = Object.keys(props)
                    .map((key) => {
                    const prop = props[key];
                    return prop ? `${key}="${prop}"` : "";
                })
                    .join("");
            }
            return html `<path ${attributes} d="${svgPath}" />`;
        }
    })
        .join("");
}
