import css from "../../services/css.js";
const styles = css `
  eden-image-cropper {
    width: 100%;
    height: 100%;
  }

  .cropper-main {
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 10px;
    overflow: hidden;
    position: relative;
  }

  .cropper-loader {
    position: absolute;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 16px;
    z-index: 10;
  }

  .cropper-loader__spinner {
    width: 26px;
    height: 26px;
    border: 3px solid rgba(255, 255, 255, 0.1);
    border-top-color: var(--eden-primary-color);
    border-radius: 50%;
    animation: cropper-spin 0.8s var(--eden-transition-easing) infinite;
  }

  @keyframes cropper-spin {
    to {
      transform: rotate(360deg);
    }
  }

  .cropper-loader__text {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
  }

  .cropper-container {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .cropper-loader + .cropper-container {
    display: none;
  }

  .cropper-image {
    max-width: 100%;
    width: auto;
    max-height: 80vh;
    height: auto;
    user-select: none;
    pointer-events: none;
    opacity: 0;
    transition: opacity 0.3s ease;
  }

  .cropper-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    pointer-events: none;
  }

  .crop-box {
    position: absolute;
    box-shadow: 0 0 0 9999px rgba(0, 0, 0, 0.25);
    cursor: move;
    user-select: none;
  }

  .crop-box::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border: 1px dashed rgba(255, 255, 255, 0.5);
    pointer-events: none;
  }

  .crop-box__grid {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
  }

  .crop-box__grid-line {
    position: absolute;
    background-color: rgba(255, 255, 255, 0.3);
  }

  .crop-box__grid-line--horizontal {
    width: 100%;
    height: 1px;
  }

  .crop-box__grid-line--vertical {
    width: 1px;
    height: 100%;
  }

  .crop-box__grid-line:nth-child(1) {
    top: 33.33%;
  }

  .crop-box__grid-line:nth-child(2) {
    top: 66.66%;
  }

  .crop-box__grid-line:nth-child(3) {
    left: 33.33%;
  }

  .crop-box__grid-line:nth-child(4) {
    left: 66.66%;
  }

  .crop-box__handle {
    position: absolute;
    width: 8px;
    height: 8px;
    background-color: var(--eden-primary-color);
    border: 1px solid var(--eden-grey-600);
    border-radius: var(--eden-radius-100);
    box-shadow: var(--eden-shadow-200);
    z-index: 1;
  }

  .crop-box__handle--nw {
    top: -5px;
    left: -5px;
    cursor: nw-resize;
  }

  .crop-box__handle--ne {
    top: -5px;
    right: -5px;
    cursor: ne-resize;
  }

  .crop-box__handle--sw {
    bottom: -5px;
    left: -5px;
    cursor: sw-resize;
  }

  .crop-box__handle--se {
    bottom: -5px;
    right: -5px;
    cursor: se-resize;
  }
`;
export default styles;
