import html from "../../services/html.js";
import t from "../../i18n/index.js";
export default function template(list, storage, width, height, uploadOnly, coldStart) {
    const { allowControls = false, breadcrumb = [], files = [] } = list;
    return html `${renderActions(allowControls, uploadOnly)}
    ${renderList(files, width, height, coldStart)}
    <footer>${renderBreadcrumb(breadcrumb)} ${renderProgress(storage)}</footer>
    ${renderUploadInput()}`;
}
function renderList(files, width, height, coldStart) {
    const { edenApi } = window.EdenConfig;
    return html `<div class="list">
    ${files
        .map((file) => {
        if (file.kind === "directory") {
            const { name, path } = file;
            return html `<button
            data-path="${path}"
            data-folder=""
            class="list__item list__item--directory"
          >
            <span class="list__item-preview">
              <eden-icon code="folder" class="list__folder-icon"></eden-icon
            ></span>
            <span class="list__item-name">${name}</span>
          </button>`;
        }
        const { name, path, thumb, metadata } = file;
        const rand = crypto.randomUUID();
        const thumbnail = edenApi.concat(thumb, "?r=", rand);
        const disabled = (width && width > metadata.width) ||
            (height && height > metadata.height);
        const disabledAttribute = disabled ? 'disabled=""' : "";
        const tooSmallWarning = disabled
            ? html `<small class="list__item-warning">Trop petite</small>`
            : "";
        const loadingAttribute = coldStart ? `data-loading=""` : "";
        const imgSrcAttribute = coldStart ? "data-src" : "src";
        return html `<button
          is="eden-button"
          class="list__item list__item--image"
          data-path="${path}"
          data-image=""
          tooltip="<b>${metadata.width}</b>x<b>${metadata.height}</b> <b>${metadata.size}</b>"
          ${loadingAttribute}
          ${disabledAttribute}
        >
          <span class="list__item-preview">
            <img ${imgSrcAttribute}="${thumbnail}" alt="" />
            ${tooSmallWarning}
          </span>
          <span class="list__item-name">${name}</span>
        </button>`;
    })
        .join("")}
  </div>`;
}
function renderBreadcrumb(items) {
    return html `<div class="breadcrumb">
    ${items
        .map((item, index) => {
        const { path, name } = item;
        const first = index === 0;
        const tooltip = first ? `tooltip="${t("modals.file-manager.back-to-home")}"` : "";
        return html `
          <button
            is="eden-button"
            class="breadcrumb__item"
            data-path="${path}"
            data-folder=""
            ${tooltip}
          >
            ${first
            ? html `<eden-icon
                  code="home"
                  class="breadcrumb__icon"
                ></eden-icon>`
            : name}
          </button>
          <div class="separator"></div>
        `;
    })
        .join("")}
  </div>`;
}
function renderActions(allowControls, uploadOnly) {
    const disabledAttribute = allowControls ? "" : 'disabled=""';
    const selectButton = uploadOnly
        ? ""
        : html `<div class="separator"></div>
        <button
          is="eden-button"
          class="action"
          data-action="select"
          tooltip="${t("modals.file-manager.select-image")}"
          ${disabledAttribute}
        >
          <eden-icon code="check" class="action__icon"></eden-icon>
        </button>`;
    return html `<div class="actions">
    <button
      is="eden-button"
      class="action"
      data-action="back"
      tooltip="${t("modals.file-manager.back-to-parent")}"
      ${disabledAttribute}
    >
      <eden-icon code="arrow_left" class="action__icon"></eden-icon>
    </button>
    <button
      is="eden-button"
      class="action"
      data-action="home"
      tooltip="${t("modals.file-manager.home")}"
      ${disabledAttribute}
    >
      <eden-icon code="home" class="action__icon"></eden-icon>
    </button>
    <div class="separator"></div>
    <button
      is="eden-button"
      class="action"
      data-action="add-folder"
      tooltip="${t("modals.file-manager.create-folder")}"
      ${disabledAttribute}
    >
      <eden-icon code="add_folder" class="action__icon"></eden-icon>
    </button>
    <button
      is="eden-button"
      class="action"
      data-action="file-upload"
      tooltip="${t("modals.file-manager.upload-file")}"
      ${disabledAttribute}
    >
      <eden-icon code="file_upload" class="action__icon"></eden-icon>
    </button>
    <div class="separator"></div>
    <button
      is="eden-button"
      class="action"
      data-action="rename"
      tooltip="${t("modals.file-manager.rename-selected")}"
      ${disabledAttribute}
    >
      <eden-icon code="rename" class="action__icon"></eden-icon>
    </button>
    <button
      is="eden-button"
      class="action"
      data-action="move"
      tooltip="${t("modals.file-manager.move-selected")}"
      ${disabledAttribute}
    >
      <eden-icon code="move" class="action__icon"></eden-icon>
    </button>
    <button
      is="eden-button"
      class="action"
      data-action="optimize"
      tooltip="${t("modals.file-manager.optimize-image")}"
      ${disabledAttribute}
    >
      <eden-icon code="optimize" class="action__icon"></eden-icon>
    </button>
    <button
      is="eden-button"
      class="action"
      data-action="rotate"
      tooltip="${t("modals.file-manager.rotate-image")}"
      ${disabledAttribute}
    >
      <eden-icon code="rotate" class="action__icon"></eden-icon>
    </button>
    <div class="separator"></div>
    <button
      is="eden-button"
      class="action"
      data-action="remove"
      tooltip="${t("modals.file-manager.remove-selected")}"
      ${disabledAttribute}
    >
      <eden-icon code="delete" class="action__icon"></eden-icon>
    </button>
    <div class="separator"></div>
    <div class="spacer"></div>
    ${selectButton}
  </div>`;
}
function renderProgress(storage) {
    const { used, max, ratio } = storage;
    let className = "progress";
    if (ratio >= 70) {
        className = "progress progres--warn";
    }
    if (ratio >= 90) {
        className = "progress progress--error";
    }
    return html `
    <div class="${className}">
      ${formatBytes(used, 0)}/${formatBytes(max, 0)}
      <progress id="file" max="100" value="${ratio}">${ratio}%</progress>
      ${ratio}%
    </div>
  `;
}
function renderUploadInput() {
    const allowedExtensions = ["jpg", "jpeg", "png"]
        .map((extension) => {
        if (extension === "xsl") {
            return "application/vnd.ms-excel";
        }
        if (extension === "xslx") {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        return `.${extension}`;
    })
        .join(",");
    return html `
    <input
      id="upload-input"
      type="file"
      accept="${allowedExtensions}"
      tabindex="-1"
      hidden=""
      multiple=""
    />
  `;
}
export function imagePreviewTemplate(path) {
    const { edenApi, site } = window.EdenConfig;
    const rand = crypto.randomUUID();
    const image = edenApi.concat("/api/files/image/", site, path, "?r=", rand);
    return html `
    <style>
      .image-preview {
        width: auto;
        max-width: 80vw;
        height: auto;
        max-height: 80vh;
        margin: auto;
        object-fit: contain;
      }
    </style>
    <img class="image-preview" src="${image}" alt="" />
  `;
}
function formatBytes(bytes, decimals = 1) {
    if (!Number(bytes))
        return "0";
    const k = 1000;
    const dm = decimals < 0 ? 0 : decimals;
    const sizes = ["o", "ko", "mo", "go", "to", "po", "eo", "zo", "yo"];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))}${sizes[i]}`;
}
