var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenTooltip_setPosition;
import styles from "./eden-tooltip.styles.js";
const OFFSET = 4;
class EdenTooltip extends HTMLElement {
    constructor(anchor, tooltip, direction) {
        super();
        _EdenTooltip_setPosition.set(this, () => {
            this.anchorBounds = this.anchor.getBoundingClientRect();
            const { width, height } = this.getBoundingClientRect();
            const defaultY = this.anchorBounds.y + this.anchorBounds.height + OFFSET;
            const defaultX = this.anchorBounds.x + this.anchorBounds.width / 2 - width / 2;
            const onTopRight = this.direction === "top-right";
            const onTopLeft = this.direction === "top-left";
            const onBottomRight = this.direction === "bottom-right";
            const onBottomLeft = this.direction === "bottom-left";
            const onRight = this.direction === "right" || defaultX < 0;
            const onLeft = this.direction === "left" || defaultX + width > window.innerWidth;
            const onTop = this.direction === "top" || defaultY + height > window.innerHeight;
            const anchorHalfHeight = this.anchorBounds.height / 2;
            if (onTopLeft) {
                const left = window.scrollX + this.anchorBounds.x + this.anchorBounds.width - width;
                const top = window.scrollY + this.anchorBounds.y - height - OFFSET;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            if (onTopRight) {
                const left = window.scrollX + this.anchorBounds.x;
                const top = window.scrollY + this.anchorBounds.y - height - OFFSET;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            if (onBottomLeft) {
                const left = window.scrollX + this.anchorBounds.x + this.anchorBounds.width - width;
                const top = window.scrollY +
                    this.anchorBounds.y +
                    this.anchorBounds.height +
                    OFFSET;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            if (onBottomRight) {
                const left = window.scrollX + this.anchorBounds.x;
                const top = window.scrollY +
                    this.anchorBounds.y +
                    this.anchorBounds.height +
                    OFFSET;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            if (onRight) {
                const left = window.scrollX + this.anchorBounds.x + this.anchorBounds.width + OFFSET;
                const top = window.scrollY + this.anchorBounds.y + anchorHalfHeight - height / 2;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            if (onLeft) {
                const left = window.scrollX + this.anchorBounds.x - width - OFFSET;
                const top = window.scrollY + this.anchorBounds.y + anchorHalfHeight - height / 2;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            if (onTop) {
                const left = window.scrollX + defaultX;
                const top = window.scrollY + this.anchorBounds.y - height - OFFSET;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
                return;
            }
            this.style.left = `${window.scrollX + defaultX}px`;
            this.style.top = `${window.scrollY + defaultY}px`;
        });
        this.anchor = anchor;
        this.tooltip = tooltip;
        this.direction = direction;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = this.tooltip;
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() {
        __classPrivateFieldGet(this, _EdenTooltip_setPosition, "f").call(this);
        this.timeout = setTimeout(() => this.remove(), 10000);
    }
    disconnectedCallback() {
        clearTimeout(this.timeout);
    }
}
_EdenTooltip_setPosition = new WeakMap();
if (!customElements.get("eden-tooltip")) {
    customElements.define("eden-tooltip", EdenTooltip);
}
export default EdenTooltip;
