import css from "../../services/css.js";
const styles = css `
  :host {
    position: fixed;
    bottom: calc(var(--eden-main-ui-height) + 16px);
    right: 16px;
    max-width: 100%;
    display: flex;
    align-items: center;
    padding: 6px 12px;
    color: var(--eden-grey-000);
    font-family: var(--eden-content-font);
    font-size: 14px;
    font-weight: 700;
    border-radius: var(--eden-radius-100);
    box-shadow: var(--eden-shadow-200);
    user-select: none;
    overflow: hidden;
    z-index: 860;
    animation: eden-snackbar-appearance 320ms var(--eden-transition-easing);
    transition-property: opacity, transform;
    transition: 320ms var(--eden-transition-easing);
  }

  @keyframes eden-snackbar-appearance {
    0% {
      opacity: 0;
      transform: translateX(10px);
    }
    100% {
      opacity: 1;
      transform: none;
    }
  }

  :host([type="success"]) {
    background: var(--eden-green-gradient);
  }

  :host([type="error"]) {
    background: var(--eden-red-gradient);
  }

  :host([type="warning"]) {
    background: var(--eden-yellow-gradient);
  }

  :host([type="information"]) {
    color: var(--eden-grey-600);
    background: var(--eden-grey-gradient);
  }

  :host([animate]) {
    opacity: 0;
    transform: translateY(-120%);
  }

  .snackbar__message {
    flex: 0 1 auto;
    display: flex;
    align-items: center;
    white-space: nowrap;
  }

  .snackbar__icon {
    position: absolute;
    top: 50%;
    left: 4px;
    width: 28px;
    height: 28px;
    fill: currentcolor;
    opacity: 0.3;
    transform-origin: top center;
    transform: translateY(-50%);
    animation: eden-snackbar-icon-appearance 1280ms
      var(--eden-transition-easing);
  }

  @keyframes eden-snackbar-icon-appearance {
    0% {
      opacity: 0;
      transform: translate(-10px, -50%);
    }
    100% {
      opacity: 0.3;
      transform: translateY(-50%);
    }
  }

  .snackbar__close {
    flex: 0 0 auto;
    width: 22px;
    height: 22px;
    margin: 0 0 0 8px;
    padding: 3px;
    box-sizing: border-box;
    fill: var(--eden-grey-000);
    border-radius: 50%;
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing);
    z-index: 1;
  }

  .snackbar__close:hover {
    background-color: rgba(0, 0, 0, 0.1);
  }
`;
export default styles;
