import css from "../../services/css.js";
import keyShortcutsStyles from "../styles/eden-key-shortcuts-styles.js";
const styles = css `
  :host {
    --top-padding: 40px;

    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: calc(100% - var(--eden-main-ui-height));
    display: flex;
    padding: var(--top-padding) 16px 0;
    box-sizing: border-box;
    font-family: var(--eden-content-font);
    font-weight: 400;
    color: var(--eden-grey-500);
    z-index: 850;
    overflow: auto;
  }

  :host([fullScreen]) {
    padding: 0;
  }

  .backdrop {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.25);
    animation: backdrop-fade-in 240ms var(--eden-transition-easing);
  }

  @keyframes backdrop-fade-in {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) .backdrop {
    animation: backdrop-fade-out 240ms var(--eden-transition-easing);
  }

  @keyframes backdrop-fade-out {
    100% {
      opacity: 0;
    }
  }

  .modal {
    position: relative;
    max-width: 95%;
    min-height: 130px;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    justify-content: space-between;
    margin: auto auto 0;
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    border-radius: var(--eden-radius-300) var(--eden-radius-300) 0 0;
    box-shadow: var(--eden-shadow-100);
    z-index: 1;
    animation: modal-fade-in 240ms var(--eden-transition-easing);
  }

  @keyframes modal-fade-in {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) .modal {
    animation: modal-fade-out 240ms var(--eden-transition-easing);
  }

  @keyframes modal-fade-out {
    100% {
      opacity: 0;
    }
  }

  :host([fullScreen]) .modal {
    width: 100%;
    max-width: 100%;
    min-width: 100%;
    height: 100%;
    max-height: 100%;
    min-height: 100%;
    border-radius: 0;
  }

  .modal__header {
    position: sticky;
    top: calc(0px - var(--top-padding));
    z-index: 10;
  }

  .modal__close-button {
    position: absolute;
    top: 4px;
    right: 4px;
    width: 37px;
    height: 37px;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-200);
    cursor: pointer;
    box-shadow: 0 0 0 1px transparent inset;
    z-index: 1;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .modal__close-button:hover {
    background-color: var(--eden-grey-100);
  }

  .modal__close-button:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .modal__close-button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .modal__close-button-icon {
    width: 20px;
    height: 20px;
    fill: var(--eden-grey-500);
  }

  .modal__title {
    flex: 0 0 auto;
    display: flex;
    align-items: center;
    padding: 12px 45px 12px 8px;
    box-sizing: border-box;
    font-size: 17px;
    line-height: 1;
    font-weight: 700;
    background: var(--eden-grey-gradient);
    border-radius: var(--eden-radius-300) var(--eden-radius-300) 0 0;
    border-bottom: 1px solid;
    border-image: linear-gradient(
        to right,
        var(--eden-grey-200) 0%,
        var(--eden-grey-100) 100%
      )
      1;
  }

  .modal__title-icon {
    flex: 0 0 20px;
    height: 20px;
    margin-right: 1ch;
    fill: currentcolor;
  }

  .modal__content {
    flex: 1 1 100%;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    padding: 12px;
    background-color: var(--eden-grey-000);
  }

  .modal--no-padding .modal__content {
    padding: 0;
  }

  .modal:has(.modal__buttons:empty) .modal__content {
  }

  .modal__buttons {
    position: sticky;
    bottom: 0;
    flex: 0 0 auto;
    display: flex;
    justify-content: flex-end;
    background: var(--eden-grey-gradient);
    border-top: 1px solid;
    border-image: linear-gradient(
        to right,
        var(--eden-grey-200) 0%,
        var(--eden-grey-100) 100%
      )
      1;
    z-index: 10;
    overflow: hidden;
  }

  .modal__buttons:empty {
    padding: 0;
    border-top: none;
  }

  .modal__button {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 10px 15px;
    font-size: 16px;
    text-decoration: none;
    font-weight: 700;
    font-family: inherit;
    color: var(--eden-primary-color);
    background-color: var(--eden-grey-100);
    border: 0;
    box-shadow: 0 0 0 1px transparent inset;
    user-select: none;
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .modal__button:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .modal__button--default:hover,
  .modal__button--cancel:hover {
    background-color: var(--eden-grey-200);
  }

  .modal__button:focus {
    outline: none;
  }

  .modal__button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .modal__button.modal__button--option {
    margin: 0 auto 0 0;
    color: var(--eden-grey-000);
    background-color: var(--eden-yellow-400);
  }

  .modal__button.modal__button--confirm {
    color: var(--eden-grey-000);
    background-color: var(--eden-primary-color);
  }

  .modal__button.modal__button--confirm:hover {
    background-color: var(--eden-secondary-color);
  }

  .modal__button.modal__button--danger {
    color: var(--eden-red-500, #d55858);
    background-color: var(--eden-red-100);
  }

  .modal__button.modal__button--disabled {
    filter: grayscale(25%) opacity(0.6);
    pointer-events: none;
  }

  .modal__button.modal__button--confirm.spin {
    padding: 5px 0px;
    pointer-events: none;
  }

  .spinner {
    width: 20px;
    height: 20px;
    fill: currentcolor;
    animation: save-spinning 1280ms var(--eden-transition-easing) infinite;
  }

  @keyframes save-spinning {
    100% {
      transform: rotate(360deg);
    }
  }

  ${keyShortcutsStyles()}
`;
export default styles;
