import html from "../../services/html.js";
export default function render({ name, label, pill, type, autofocus, autocomplete, value, placeholder, helper, spellCheck, pattern, inputStyles, children, }) {
    const className = type === "select"
        ? "eden-input__input-container eden-input__input-container--select"
        : "eden-input__input-container";
    const autofocusAttr = autofocus ? "autoFocus" : "";
    const placeholderAttr = placeholder ? `placeholder="${placeholder}"` : "";
    const customInputStyles = inputStyles ? `style="${inputStyles}"` : "";
    const pillElement = pill ? html ` <span class="${pill}"></span>` : "";
    const patternAttr = pattern ? `pattern="${pattern}"` : "";
    const autocompleteAttr = autocomplete ? `autocomplete="${autocomplete}"` : "";
    const isAutocompleteOff = autocomplete === "off";
    const listIfAttr = isAutocompleteOff ? `list="${name}"` : "";
    const autocompleteList = isAutocompleteOff
        ? html `<datalist id="${name}"></datalist>`
        : "";
    return html `
    ${renderLabel(name, pillElement, label)}
    <div class="${className}">
      ${renderItem(type, name, placeholderAttr, autofocusAttr, autocompleteAttr, listIfAttr, patternAttr, customInputStyles, value, spellCheck, children)}
      ${autocompleteList} ${renderHelper(helper)}
    </div>
  `;
}
function renderItem(type, name, placeholderAttr, autofocusAttr, autocompleteAttr, listIfAttr, patternAttr, customInputStyles, value, spellCheck, children) {
    if (type === "select") {
        return html `
      <select
        class="eden-input__input eden-input__input--select"
        id="${name}"
        name="${name}"
        ${autofocusAttr}
        ${customInputStyles}
      >
        ${children}
      </select>
    `;
    }
    if (type === "textarea") {
        return html `<textarea
      class="eden-input__input eden-input__input--textarea"
      id="${name}"
      name="${name}"
      value="${value}"
      spellcheck="${spellCheck}"
      ${autofocusAttr}
      ${autocompleteAttr}
      ${listIfAttr}
      ${placeholderAttr}
      ${customInputStyles}
    ></textarea>`;
    }
    return html `<input
    class="eden-input__input"
    type="${type}"
    id="${name}"
    name="${name}"
    value="${value}"
    spellcheck="${spellCheck}"
    ${autofocusAttr}
    ${autocompleteAttr}
    ${listIfAttr}
    ${placeholderAttr}
    ${patternAttr}
    ${customInputStyles}
  />`;
}
function renderLabel(name, pillElement, label) {
    if (!label?.length)
        return "";
    return html `<label class="eden-input__label" for="${name}"
    >${label} ${pillElement}</label
  >`;
}
function renderHelper(helper) {
    if (!helper?.length)
        return "";
    return html `<div class="eden-input__helper">${helper}</div>`;
}
