import html from "../../services/html.js";
export default function template(options, horizontal, tooltipDirection) {
    return renderOptions(options, horizontal, tooltipDirection);
}
function renderOptions(options, horizontal, tooltipDirection) {
    return options
        .map((option) => {
        const { icon, dot, text, formatter, current, disabled, separator } = option;
        const beforeSeparator = separator === "before" ? html `<div class="separator"></div>` : "";
        const afterSeparator = separator === "after" ? html `<div class="separator"></div>` : "";
        const activeClassName = current ? "option--active" : "";
        const disabledClassName = !current && disabled ? "option--disabled" : "";
        const iconHTML = icon
            ? html `<eden-icon code="${icon}" class="option__icon"></eden-icon>`
            : "";
        const dotHTML = dot ? html `<div class="option__dot"></div>` : "";
        const classes = `option ${activeClassName} ${disabledClassName}`.trim();
        const label = formatter ? formatter(option) : text;
        const tooltipAttribute = horizontal ? `tooltip="${label}"` : "";
        return html ` ${beforeSeparator}
        <button
          is="eden-button"
          type="button"
          ${tooltipAttribute}
          direction="${tooltipDirection}"
          class="${classes}"
        >
          ${iconHTML} ${dotHTML} ${horizontal ? "" : label}
        </button>
        ${afterSeparator}`;
    })
        .join("");
}
