import css from "../../services/css.js";
import keyShortcutsStyles from "../styles/eden-key-shortcuts-styles.js";
const styles = css `
  :host {
    position: absolute;
    top: calc(100% + 8px);
    max-height: 400px;
    display: flex;
    flex-direction: column;
    padding: 10px;
    box-sizing: border-box;
    font-family: var(--eden-content-font);
    font-weight: 400;
    font-size: 14px;
    color: var(--eden-grey-500);
    text-align: left;
    background-color: var(--eden-grey-000);
    border: 1px solid var(--eden-grey-200);
    border-radius: var(--eden-radius-200);
    box-shadow: var(--eden-shadow-200);
    overflow: auto;
    animation: dropdown-appearance 160ms var(--eden-transition-easing);
    z-index: 1200;
  }

  @keyframes dropdown-appearance {
    0% {
      opacity: 0;
    }
  }

  :host([horizontal]) {
    flex-direction: row;
    padding: 4px;
    gap: 4px;
    border-radius: var(--eden-radius-200);
    box-shadow: var(--eden-shadow-100);
    overflow: visible;
  }

  .option {
    position: relative;
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 6px 8px;
    color: var(--eden-grey-600);
    background-color: transparent;
    font-family: var(--eden-content-font);
    font-weight: 400;
    font-size: 15px;
    white-space: nowrap;
    user-select: none;
    text-align: left;
    border: 0;
    border-radius: var(--eden-radius-200);
    cursor: pointer;
    transition: color 160ms var(--eden-transition-easing),
      background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  :host([horizontal]) .option {
    padding: 8px;
    justify-content: center;
    border-radius: inherit;
  }

  .option--active {
    color: var(--eden-secondary-color);
    font-weight: 700;
  }

  .option:not(.option--active, .option--disabled):hover {
    background-color: var(--eden-grey-100);
  }

  :host([horizontal]) .option:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .option--active {
    background-color: var(--eden-magenta-100);
  }

  .option--disabled {
    color: var(--eden-grey-300);
    cursor: not-allowed;
  }

  .option__icon {
    flex: 0 0 16px;
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }

  .option__dot {
    position: absolute;
    top: 6px;
    left: 20px;
    width: 6px;
    border: 2px solid var(--eden-grey-000);
    height: 6px;
    border-radius: 50%;
    background-color: var(--eden-red-400);
    transition: border 160ms var(--eden-transition-easing);
  }

  .option:not(.option--active, .option--disabled):hover .option__dot {
    border: 2px solid var(--eden-grey-100);
  }

  .option--active .option__dot {
    border: 2px solid var(--eden-magenta-100);
  }

  .option__pill {
    flex: 0 0 13px;
    width: 13px;
    height: 13px;
    border-radius: var(--eden-radius-100);
    box-shadow: var(--eden-shadow-100);
  }

  ${keyShortcutsStyles({
    color: "var(--eden-grey-600)",
    backgroundColor: "var(--eden-grey-200)",
    fontSize: "12px",
    parentSelector: ":host(:not([horizontal]))",
    additionalStyles: css `
      .option .shortcut {
        margin-left: auto;
      }
    `,
})}

  .separator {
    height: 1px;
    margin: 6px 0;
    background-color: var(--eden-grey-200);
  }

  :host([horizontal]) .separator {
    flex: 0 0 1px;
    width: 1px;
    height: inherit;
    margin: 0 2px;
  }
`;
export default styles;
