var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenDropdown_instances, _EdenDropdown_setPosition, _EdenDropdown_isActive, _EdenDropdown_triggerOptionClick, _EdenDropdown_closeOnOutsideClick, _EdenDropdown_toggleActive, _EdenDropdown_onSelectionChange;
import { findParentFromSelection } from "../../bricks/RichText.js";
import template from "./eden-dropdown.template.js";
import styles from "./eden-dropdown.styles.js";
const OFFSET = 10;
class EdenDropdown extends HTMLElement {
    constructor(anchor, options, onRemove, checkDocumentSelection, horizontal, tooltipDirection) {
        super();
        _EdenDropdown_instances.add(this);
        this.direction = "bottom";
        _EdenDropdown_setPosition.set(this, () => {
            this.anchorBounds = this.anchor.getBoundingClientRect();
            const { width, height } = this.getBoundingClientRect();
            const defaultY = this.anchorBounds.y + this.anchorBounds.height + OFFSET;
            const defaultX = this.anchorBounds.x + this.anchorBounds.width / 2 - width / 2;
            const onRight = this.direction === "right" || defaultX < 0;
            const onLeft = this.direction === "left" || defaultX + width > window.innerWidth;
            const onTop = this.direction === "top" || defaultY + height > window.innerHeight;
            const anchorHalfHeight = this.anchorBounds.height / 2;
            if (onRight) {
                const left = window.scrollX + this.anchorBounds.x + this.anchorBounds.width + OFFSET;
                const top = window.scrollY + this.anchorBounds.y + anchorHalfHeight - height / 2;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
            }
            else if (onLeft) {
                const left = window.scrollX + this.anchorBounds.x - width - OFFSET;
                const top = window.scrollY + this.anchorBounds.y + anchorHalfHeight - height / 2;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
            }
            else if (onTop) {
                const left = window.scrollX + defaultX;
                const top = window.scrollY + this.anchorBounds.y - height - OFFSET;
                this.style.left = `${left}px`;
                this.style.top = `${top}px`;
            }
            else {
                this.style.left = `${window.scrollX + defaultX}px`;
                this.style.top = `${window.scrollY + defaultY}px`;
            }
        });
        _EdenDropdown_triggerOptionClick.set(this, (e) => {
            e.preventDefault();
            const target = e.target;
            if (!target)
                return;
            const option = target.closest(".option");
            const index = option.dataset.index
                ? parseInt(option.dataset.index, 10)
                : null;
            if (index !== null &&
                this.options[index].onClick &&
                !this.options[index].disabled) {
                this.options[index].onClick?.(e);
                if (typeof this.onRemove === "function") {
                    this.onRemove();
                }
            }
        });
        _EdenDropdown_closeOnOutsideClick.set(this, (e) => {
            const target = e.target;
            const isClickingOnAnchor = this.anchor.contains(target);
            const isClickingOnContent = this.contains(target);
            if (isClickingOnAnchor || isClickingOnContent)
                return;
            if (typeof this.onRemove === "function") {
                this.onRemove();
            }
        });
        _EdenDropdown_toggleActive.set(this, (condition, index) => {
            if (condition) {
                this.optionsElement[index].classList.add("option--active");
            }
            else {
                this.optionsElement[index].classList.remove("option--active");
            }
        });
        _EdenDropdown_onSelectionChange.set(this, () => {
            this.options.forEach((option, i) => {
                const active = __classPrivateFieldGet(this, _EdenDropdown_instances, "m", _EdenDropdown_isActive).call(this, option);
                __classPrivateFieldGet(this, _EdenDropdown_toggleActive, "f").call(this, active, i);
            });
        });
        this.anchor = anchor;
        this.options = options;
        this.onRemove = onRemove;
        this.checkDocumentSelection = checkDocumentSelection;
        this.horizontal = horizontal;
        this.tooltipDirection = tooltipDirection;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template(this.options, this.horizontal, this.tooltipDirection);
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() {
        this.optionsElement = Array.from(this.shadowRoot.querySelectorAll(".option"));
        if (this.horizontal) {
            this.setAttribute("horizontal", "");
        }
        this.optionsElement.forEach((optionElement, index) => {
            if (this.options[index].onClick && !this.options[index].disabled) {
                optionElement.setAttribute("data-index", index.toString());
                optionElement.addEventListener("click", __classPrivateFieldGet(this, _EdenDropdown_triggerOptionClick, "f"));
            }
        });
        __classPrivateFieldGet(this, _EdenDropdown_setPosition, "f").call(this);
        if (this.checkDocumentSelection) {
            __classPrivateFieldGet(this, _EdenDropdown_onSelectionChange, "f").call(this);
            document.addEventListener("selectionchange", __classPrivateFieldGet(this, _EdenDropdown_onSelectionChange, "f"));
        }
        window.addEventListener("scroll", this.onRemove);
        document.addEventListener("click", __classPrivateFieldGet(this, _EdenDropdown_closeOnOutsideClick, "f"));
    }
    disconnectedCallback() {
        document.removeEventListener("click", __classPrivateFieldGet(this, _EdenDropdown_closeOnOutsideClick, "f"));
        window.removeEventListener("scroll", this.onRemove);
        if (this.checkDocumentSelection) {
            document.removeEventListener("selectionchange", __classPrivateFieldGet(this, _EdenDropdown_onSelectionChange, "f"));
        }
        this.optionsElement.forEach((optionElement, index) => {
            if (this.options[index].onClick) {
                optionElement.removeEventListener("click", __classPrivateFieldGet(this, _EdenDropdown_triggerOptionClick, "f"));
            }
        });
        if (typeof this.onRemove === "function") {
            this.onRemove();
        }
    }
}
_EdenDropdown_setPosition = new WeakMap(), _EdenDropdown_triggerOptionClick = new WeakMap(), _EdenDropdown_closeOnOutsideClick = new WeakMap(), _EdenDropdown_toggleActive = new WeakMap(), _EdenDropdown_onSelectionChange = new WeakMap(), _EdenDropdown_instances = new WeakSet(), _EdenDropdown_isActive = function _EdenDropdown_isActive(option) {
    const parentSpan = findParentFromSelection("span");
    if (!parentSpan)
        return false;
    const checkStyles = !!option.value;
    if (checkStyles && option.property) {
        return (parentSpan.style?.[option.property] ===
            option.value);
    }
    else {
        return parentSpan.classList.contains(option.text);
    }
};
export default EdenDropdown;
if (!customElements.get("eden-dropdown")) {
    customElements.define("eden-dropdown", EdenDropdown);
}
